/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cache.Cache;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.CacheControl;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.config.ResourceChainRegistration;
import org.springframework.web.reactive.resource.ResourceWebHandler;

public class ResourceHandlerRegistration {
    private final ResourceLoader resourceLoader;
    private final String[] pathPatterns;
    private final List<String> locationValues = new ArrayList<String>();
    @Nullable
    private CacheControl cacheControl;
    @Nullable
    private ResourceChainRegistration resourceChainRegistration;
    private boolean useLastModified = true;
    private boolean optimizeLocations = false;
    @Nullable
    private Map<String, MediaType> mediaTypes;

    public ResourceHandlerRegistration(ResourceLoader resourceLoader, String ... pathPatterns) {
        Assert.notNull((Object)resourceLoader, "ResourceLoader is required");
        Assert.notEmpty((Object[])pathPatterns, "At least one path pattern is required for resource handling");
        this.resourceLoader = resourceLoader;
        this.pathPatterns = pathPatterns;
    }

    public ResourceHandlerRegistration addResourceLocations(String ... resourceLocations) {
        this.locationValues.addAll(Arrays.asList(resourceLocations));
        return this;
    }

    public ResourceHandlerRegistration setCacheControl(CacheControl cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public ResourceHandlerRegistration setUseLastModified(boolean useLastModified) {
        this.useLastModified = useLastModified;
        return this;
    }

    public ResourceHandlerRegistration setOptimizeLocations(boolean optimizeLocations) {
        this.optimizeLocations = optimizeLocations;
        return this;
    }

    public ResourceChainRegistration resourceChain(boolean cacheResources) {
        this.resourceChainRegistration = new ResourceChainRegistration(cacheResources);
        return this.resourceChainRegistration;
    }

    public ResourceChainRegistration resourceChain(boolean cacheResources, Cache cache) {
        this.resourceChainRegistration = new ResourceChainRegistration(cacheResources, cache);
        return this.resourceChainRegistration;
    }

    public void setMediaTypes(Map<String, MediaType> mediaTypes) {
        if (this.mediaTypes == null) {
            this.mediaTypes = new HashMap<String, MediaType>(mediaTypes.size());
        }
        this.mediaTypes.clear();
        this.mediaTypes.putAll(mediaTypes);
    }

    protected String[] getPathPatterns() {
        return this.pathPatterns;
    }

    protected ResourceWebHandler getRequestHandler() {
        ResourceWebHandler handler = new ResourceWebHandler();
        handler.setResourceLoader(this.resourceLoader);
        handler.setLocationValues(this.locationValues);
        if (this.resourceChainRegistration != null) {
            handler.setResourceResolvers(this.resourceChainRegistration.getResourceResolvers());
            handler.setResourceTransformers(this.resourceChainRegistration.getResourceTransformers());
        }
        if (this.cacheControl != null) {
            handler.setCacheControl(this.cacheControl);
        }
        handler.setUseLastModified(this.useLastModified);
        handler.setOptimizeLocations(this.optimizeLocations);
        if (this.mediaTypes != null) {
            handler.setMediaTypes(this.mediaTypes);
        }
        return handler;
    }
}

