/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import io.undertow.server.HttpServerExchange;
import io.undertow.websockets.WebSocketConnectionCallback;
import io.undertow.websockets.WebSocketProtocolHandshakeHandler;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.ServerHttpRequestDecorator;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ContextWebSocketHandler;
import org.springframework.web.reactive.socket.adapter.UndertowWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.UndertowWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import org.xnio.ChannelListener;
import reactor.core.publisher.Mono;

public class UndertowRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        HttpServerExchange httpExchange = (HttpServerExchange)ServerHttpRequestDecorator.getNativeRequest(exchange2.getRequest());
        Set<Object> protocols = subProtocol != null ? Collections.singleton(subProtocol) : Collections.emptySet();
        Hybi13Handshake handshake = new Hybi13Handshake(protocols, false);
        List<Hybi13Handshake> handshakes = Collections.singletonList(handshake);
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        DataBufferFactory bufferFactory = exchange2.getResponse().bufferFactory();
        return exchange2.getResponse().setComplete().then(Mono.deferContextual(contextView -> {
            DefaultCallback callback = new DefaultCallback(handshakeInfo, ContextWebSocketHandler.decorate(handler, contextView), bufferFactory);
            try {
                new WebSocketProtocolHandshakeHandler((Collection)handshakes, (WebSocketConnectionCallback)callback).handleRequest(httpExchange);
            }
            catch (Exception ex) {
                return Mono.error(ex);
            }
            return Mono.empty();
        }));
    }

    private class DefaultCallback
    implements WebSocketConnectionCallback {
        private final HandshakeInfo handshakeInfo;
        private final WebSocketHandler handler;
        private final DataBufferFactory bufferFactory;

        public DefaultCallback(HandshakeInfo handshakeInfo, WebSocketHandler handler, DataBufferFactory bufferFactory) {
            this.handshakeInfo = handshakeInfo;
            this.handler = handler;
            this.bufferFactory = bufferFactory;
        }

        public void onConnect(WebSocketHttpExchange exchange2, WebSocketChannel channel) {
            UndertowWebSocketSession session = this.createSession(channel);
            UndertowWebSocketHandlerAdapter adapter = new UndertowWebSocketHandlerAdapter(session);
            channel.getReceiveSetter().set((ChannelListener)adapter);
            channel.resumeReceives();
            this.handler.handle(session).checkpoint(exchange2.getRequestURI() + " [UndertowRequestUpgradeStrategy]").subscribe(session);
        }

        private UndertowWebSocketSession createSession(WebSocketChannel channel) {
            return new UndertowWebSocketSession(channel, this.handshakeInfo, this.bufferFactory);
        }
    }
}

