/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import reactor.netty.http.HttpResources;
import reactor.netty.http.client.Http2ConnectionProvider;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpResources;

final class Http2Resources
extends TcpResources {
    static final AtomicReference<Http2Resources> http2Resources;
    static final BiFunction<LoopResources, ConnectionProvider, Http2Resources> ON_HTTP2_NEW;

    public static Http2Resources get() {
        return Http2Resources.getOrCreate(http2Resources, null, null, ON_HTTP2_NEW, "http2");
    }

    public static Http2Resources set(ConnectionProvider provider) {
        return Http2Resources.getOrCreate(http2Resources, null, Http2Resources.newConnectionProvider(provider), ON_HTTP2_NEW, "http2");
    }

    Http2Resources(LoopResources loops, ConnectionProvider provider) {
        super(loops, provider);
    }

    static ConnectionProvider newConnectionProvider(ConnectionProvider parent) {
        ConnectionProvider.Builder builder = (ConnectionProvider.Builder)((ConnectionProvider.Builder)ConnectionProvider.builder("http2").maxConnections(parent.maxConnections())).pendingAcquireMaxCount(-1);
        if (parent.maxConnectionsPerHost() != null) {
            parent.maxConnectionsPerHost().forEach((address, maxConn) -> builder.forRemoteHost((SocketAddress)address, spec -> {
                ConnectionProvider.HostSpecificSpec cfr_ignored_0 = (ConnectionProvider.HostSpecificSpec)spec.maxConnections((int)maxConn);
            }));
        }
        return new Http2ConnectionProvider(parent, builder);
    }

    static {
        ON_HTTP2_NEW = Http2Resources::new;
        http2Resources = new AtomicReference<Http2Resources>(new Http2Resources(HttpResources.get(), Http2Resources.newConnectionProvider(HttpResources.get())));
    }
}

