/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.function.Function;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.client.HttpClientMetricsRecorder;
import reactor.netty.http.client.HttpClientOperations;
import reactor.util.annotation.Nullable;
import reactor.util.context.ContextView;

abstract class AbstractHttpClientMetricsHandler
extends ChannelDuplexHandler {
    String path;
    String method;
    String status;
    ContextView contextView;
    long dataReceived;
    long dataSent;
    long dataReceivedTime;
    long dataSentTime;
    final Function<String, String> uriTagValue;

    protected AbstractHttpClientMetricsHandler(@Nullable Function<String, String> uriTagValue) {
        this.uriTagValue = uriTagValue;
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpRequest) {
            this.method = ((HttpRequest)msg).method().name();
            ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
            if (channelOps instanceof HttpClientOperations) {
                HttpClientOperations ops = (HttpClientOperations)channelOps;
                this.path = this.uriTagValue == null ? ops.path : this.uriTagValue.apply(ops.path);
                this.contextView = ops.currentContextView();
            }
            this.dataSentTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataSent += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataSent += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            promise.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> this.recordWrite(ctx.channel().remoteAddress())));
        }
        ctx.write(msg, promise);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof HttpResponse) {
            this.status = ((HttpResponse)msg).status().codeAsText().toString();
            this.dataReceivedTime = System.nanoTime();
        }
        if (msg instanceof ByteBufHolder) {
            this.dataReceived += (long)((ByteBufHolder)msg).content().readableBytes();
        } else if (msg instanceof ByteBuf) {
            this.dataReceived += (long)((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof LastHttpContent) {
            this.recordRead(ctx.channel().remoteAddress());
            this.reset();
        }
        ctx.fireChannelRead(msg);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.recordException(ctx);
        ctx.fireExceptionCaught(cause);
    }

    protected abstract HttpClientMetricsRecorder recorder();

    protected void recordException(ChannelHandlerContext ctx) {
        this.recorder().incrementErrorsCount(ctx.channel().remoteAddress(), this.path != null ? this.path : this.resolveUri(ctx));
    }

    protected void recordRead(SocketAddress address) {
        this.recorder().recordDataReceivedTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataReceivedTime));
        this.recorder().recordResponseTime(address, this.path, this.method, this.status, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataReceived(address, this.path, this.dataReceived);
    }

    protected void recordWrite(SocketAddress address) {
        this.recorder().recordDataSentTime(address, this.path, this.method, Duration.ofNanos(System.nanoTime() - this.dataSentTime));
        this.recorder().recordDataSent(address, this.path, this.dataSent);
    }

    private String resolveUri(ChannelHandlerContext ctx) {
        ChannelOperations<?, ?> channelOps = ChannelOperations.get(ctx.channel());
        if (channelOps instanceof HttpClientOperations) {
            String path2 = ((HttpClientOperations)channelOps).uri();
            return this.uriTagValue == null ? path2 : this.uriTagValue.apply(path2);
        }
        return "unknown";
    }

    private void reset() {
        this.path = null;
        this.method = null;
        this.status = null;
        this.contextView = null;
        this.dataReceived = 0L;
        this.dataSent = 0L;
        this.dataReceivedTime = 0L;
        this.dataSentTime = 0L;
    }
}

