/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.webclient.client;

import feign.MethodMetadata;
import feign.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.function.BiFunction;
import org.reactivestreams.Publisher;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.reactive.ClientHttpRequest;
import org.springframework.web.reactive.function.BodyInserter;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.WebClient;
import reactivefeign.client.ReactiveFeignException;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.utils.FeignUtils;
import reactivefeign.webclient.client.WebReactiveHttpEntityResponse;
import reactivefeign.webclient.client.WebReactiveHttpResponse;
import reactor.core.publisher.Mono;

public class WebReactiveHttpClient<P extends Publisher<?>>
implements ReactiveHttpClient<P> {
    private final WebClient webClient;
    private final ParameterizedTypeReference<Object> bodyActualType;
    private final BiFunction<ReactiveHttpRequest, ClientResponse, ReactiveHttpResponse<P>> responseFunction;
    private final BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper;

    public static <P extends Publisher<?>> WebReactiveHttpClient<P> webClient(MethodMetadata methodMetadata, WebClient webClient, BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper) {
        Class returnPublisherType = FeignUtils.returnPublisherType(methodMetadata);
        ParameterizedTypeReference returnActualType = ParameterizedTypeReference.forType(FeignUtils.returnActualType(methodMetadata));
        ParameterizedTypeReference bodyActualType = Optional.ofNullable(FeignUtils.getBodyActualType(methodMetadata.bodyType())).map(ParameterizedTypeReference::forType).orElse(null);
        if (returnActualType.getType() instanceof ParameterizedType && ((ParameterizedType)returnActualType.getType()).getRawType().equals(ResponseEntity.class)) {
            Type entityType = Util.resolveLastTypeParameter(returnActualType.getType(), ResponseEntity.class);
            Class entityPublisherType = FeignUtils.returnPublisherType(entityType);
            ParameterizedTypeReference entityActualType = ParameterizedTypeReference.forType(FeignUtils.returnActualType(entityType));
            return new WebReactiveHttpClient<P>(webClient, bodyActualType, (request, response) -> new WebReactiveHttpEntityResponse((ReactiveHttpRequest)request, (ClientResponse)response, entityPublisherType, entityActualType), errorMapper);
        }
        return new WebReactiveHttpClient<P>(webClient, bodyActualType, WebReactiveHttpClient.webReactiveHttpResponse(returnPublisherType, returnActualType), errorMapper);
    }

    public static <P extends Publisher<?>> BiFunction<ReactiveHttpRequest, ClientResponse, ReactiveHttpResponse<P>> webReactiveHttpResponse(Type returnPublisherType, ParameterizedTypeReference<?> returnActualType) {
        return (request, response) -> new WebReactiveHttpResponse((ReactiveHttpRequest)request, (ClientResponse)response, returnPublisherType, returnActualType);
    }

    public WebReactiveHttpClient(WebClient webClient, ParameterizedTypeReference<Object> bodyActualType, BiFunction<ReactiveHttpRequest, ClientResponse, ReactiveHttpResponse<P>> responseFunction, BiFunction<ReactiveHttpRequest, Throwable, Throwable> errorMapper) {
        this.webClient = webClient;
        this.bodyActualType = bodyActualType;
        this.responseFunction = responseFunction;
        this.errorMapper = errorMapper;
    }

    @Override
    public Mono<ReactiveHttpResponse<P>> executeRequest(ReactiveHttpRequest request) {
        return ((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webClient.method(HttpMethod.valueOf(request.method())).uri(request.uri())).headers(httpHeaders -> this.setUpHeaders(request, (HttpHeaders)httpHeaders))).body(this.provideBody(request)).exchange().onErrorMap(ex -> {
            Throwable errorMapped = this.errorMapper.apply(request, (Throwable)ex);
            if (errorMapped != null) {
                return errorMapped;
            }
            return new ReactiveFeignException((Throwable)ex, request);
        }).map(response -> this.toReactiveHttpResponse(request, (ClientResponse)response));
    }

    protected ReactiveHttpResponse<P> toReactiveHttpResponse(ReactiveHttpRequest request, ClientResponse response) {
        return this.responseFunction.apply(request, response);
    }

    protected BodyInserter<?, ? super ClientHttpRequest> provideBody(ReactiveHttpRequest request) {
        return this.bodyActualType != null ? BodyInserters.fromPublisher(request.body(), this.bodyActualType) : BodyInserters.empty();
    }

    protected void setUpHeaders(ReactiveHttpRequest request, HttpHeaders httpHeaders) {
        request.headers().forEach(httpHeaders::put);
    }
}

