/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.utils;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class LazyInitialized<V> {
    private final AtomicReference<V> cachedValue = new AtomicReference();
    private final Supplier<V> supplier;

    public LazyInitialized(Supplier<V> supplier) {
        this.supplier = supplier;
    }

    public V get() {
        V result = this.cachedValue.get();
        if (result == null && !this.cachedValue.compareAndSet(null, result = this.supplier.get())) {
            return this.cachedValue.get();
        }
        return result;
    }
}

