/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class WorkloadParams
implements Comparable<WorkloadParams>,
Serializable {
    private static final long serialVersionUID = 780563934988950196L;
    private final SortedMap<String, Value> params = new TreeMap<String, Value>();

    public WorkloadParams() {
    }

    private WorkloadParams(SortedMap<String, Value> params) {
        this();
        this.params.putAll(params);
    }

    @Override
    public int compareTo(WorkloadParams o) {
        if (!this.params.keySet().equals(o.params.keySet())) {
            throw new IllegalStateException("Comparing actual params with different key sets.");
        }
        for (Map.Entry<String, Value> e : this.params.entrySet()) {
            int cr = e.getValue().compareTo((Value)o.params.get(e.getKey()));
            if (cr == 0) continue;
            return cr;
        }
        return 0;
    }

    public void put(String k, String v, int vOrder) {
        this.params.put(k, new Value(v, vOrder));
    }

    public boolean containsKey(String name) {
        return this.params.containsKey(name);
    }

    public String get(String name) {
        Value value = (Value)this.params.get(name);
        if (value == null) {
            return null;
        }
        return value.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkloadParams that = (WorkloadParams)o;
        return Objects.equals(this.params, that.params);
    }

    public int hashCode() {
        return this.params != null ? this.params.hashCode() : 0;
    }

    public String toString() {
        return this.params.toString();
    }

    public WorkloadParams copy() {
        return new WorkloadParams(this.params);
    }

    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    public Collection<String> keys() {
        return this.params.keySet();
    }

    private static class Value
    implements Comparable<Value>,
    Serializable {
        private static final long serialVersionUID = 8846779314306880977L;
        private final String value;
        private final int order;

        public Value(String value, int order) {
            this.value = value;
            this.order = order;
        }

        @Override
        public int compareTo(Value o) {
            return Integer.compare(this.order, o.order);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Value value1 = (Value)o;
            return Objects.equals(this.value, value1.value);
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }
    }
}

