/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.spi.json;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.codehaus.jettison.json.JSONTokener;

public class JettisonProvider
extends AbstractJsonProvider {
    private static Object jettisonUnwrap(Object obj) {
        if (obj != null && obj.equals(JSONObject.NULL)) {
            return null;
        }
        return obj;
    }

    private static Object jettisonWrap(Object obj) {
        if (obj == null) {
            return JSONObject.NULL;
        }
        return obj;
    }

    private Object parse(JettisonTokener JsonTokener) {
        try {
            char nextChar = JsonTokener.nextClean();
            JsonTokener.back();
            if (nextChar == '{') {
                return new JettisonObject(JsonTokener);
            }
            if (nextChar == '[') {
                return new JettisonArray(JsonTokener);
            }
            throw new JSONException("Invalid JSON");
        }
        catch (JSONException jsonException) {
            throw new IllegalStateException(jsonException);
        }
    }

    @Override
    public Object parse(String json) throws InvalidJsonException {
        return this.parse(new JettisonTokener(json));
    }

    @Override
    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            int size;
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((size = jsonStream.read(buffer)) > 0) {
                stream.write(buffer, 0, size);
            }
            return this.parse(new JettisonTokener(new String(stream.toByteArray(), charset)));
        }
        catch (IOException ioe) {
            throw new InvalidJsonException(ioe);
        }
    }

    @Override
    public String toJson(Object obj) {
        try {
            if (obj instanceof JSONArray) {
                return ((JSONArray)obj).toString(2);
            }
            if (obj instanceof JSONObject) {
                return ((JSONObject)obj).toString(2);
            }
            return String.valueOf(obj);
        }
        catch (JSONException jsonException) {
            throw new IllegalStateException(jsonException);
        }
    }

    @Override
    public Object createMap() {
        return new JettisonObject();
    }

    @Override
    public Iterable<?> createArray() {
        return new JettisonArray();
    }

    @Override
    public Object unwrap(Object obj) {
        return JettisonProvider.jettisonUnwrap(obj);
    }

    @Override
    public boolean isArray(Object obj) {
        return obj instanceof JSONArray;
    }

    @Override
    public boolean isMap(Object obj) {
        return obj instanceof JSONObject;
    }

    @Override
    public int length(Object obj) {
        if (obj instanceof JSONArray) {
            return ((JSONArray)obj).length();
        }
        if (obj instanceof JSONObject) {
            return ((JSONObject)obj).length();
        }
        if (obj instanceof String) {
            return ((String)obj).length();
        }
        return 0;
    }

    @Override
    public Iterable<?> toIterable(final Object obj) {
        return new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                if (obj instanceof JSONArray) {
                    return new JettisonArrayIterator((JSONArray)obj);
                }
                if (obj instanceof JSONObject) {
                    return new JettisonObjectIterator((JSONObject)obj);
                }
                return Collections.emptyList().iterator();
            }
        };
    }

    @Override
    public Collection<String> getPropertyKeys(Object obj) {
        ArrayList<String> keys = new ArrayList<String>(this.length(obj));
        if (obj instanceof JSONArray) {
            for (int i2 = 0; i2 < this.length(obj); ++i2) {
                keys.add(String.valueOf(i2));
            }
        }
        if (obj instanceof JSONObject) {
            Iterator keysIt = ((JSONObject)obj).keys();
            while (keysIt.hasNext()) {
                keys.add(String.valueOf(keysIt.next()));
            }
        }
        return keys;
    }

    @Override
    public Object getArrayIndex(Object obj, int index) {
        return JettisonProvider.jettisonUnwrap(((JSONArray)obj).opt(index));
    }

    @Override
    public void setArrayIndex(Object array, int index, Object value) {
        if (!this.isArray(array)) {
            throw new UnsupportedOperationException();
        }
        try {
            ((JSONArray)array).put(index, JettisonProvider.jettisonWrap(value));
        }
        catch (JSONException jsonException) {
            throw new IllegalArgumentException(jsonException);
        }
    }

    @Override
    public Object getMapValue(Object obj, String key) {
        Object value = ((JSONObject)obj).opt(key);
        if (value == null) {
            return JsonProvider.UNDEFINED;
        }
        return JettisonProvider.jettisonUnwrap(value);
    }

    @Override
    public void setProperty(Object obj, Object key, Object value) {
        try {
            if (obj instanceof JSONArray) {
                int index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
                ((JSONArray)obj).put(index, JettisonProvider.jettisonWrap(value));
            }
            if (obj instanceof JSONObject) {
                ((JSONObject)obj).put(String.valueOf(key), JettisonProvider.jettisonWrap(value));
            }
        }
        catch (JSONException jsonException) {
            throw new IllegalStateException(jsonException);
        }
    }

    @Override
    public void removeProperty(Object obj, Object key) {
        try {
            if (obj instanceof JSONArray) {
                int index;
                int n = index = key instanceof Integer ? (Integer)key : Integer.parseInt(key.toString());
                if (index < this.length(obj)) {
                    Object temp = new Object();
                    ((JSONArray)obj).put(index, temp);
                    ((JSONArray)obj).remove(temp);
                }
            }
            if (obj instanceof JSONObject) {
                ((JSONObject)obj).remove(String.valueOf(key));
            }
        }
        catch (JSONException jsonException) {
            throw new IllegalStateException(jsonException);
        }
    }

    private static class JettisonObjectIterator
    implements Iterator<Object> {
        private final JSONObject jsonObject;
        private final Iterator<?> jsonKeysIt;

        private JettisonObjectIterator(JSONObject jsonObject) {
            this.jsonObject = jsonObject;
            this.jsonKeysIt = jsonObject.keys();
        }

        @Override
        public boolean hasNext() {
            return this.jsonKeysIt.hasNext();
        }

        @Override
        public Object next() {
            try {
                return JettisonProvider.jettisonUnwrap(this.jsonObject.get(String.valueOf(this.jsonKeysIt.next())));
            }
            catch (JSONException jsonException) {
                throw new NoSuchElementException(jsonException.toString());
            }
        }

        @Override
        public void remove() {
            this.jsonKeysIt.remove();
        }
    }

    private static class JettisonArrayIterator
    implements Iterator<Object> {
        private final JSONArray jsonArray;
        private int index = 0;

        private JettisonArrayIterator(JSONArray jsonArray) {
            this.jsonArray = jsonArray;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.jsonArray.length();
        }

        @Override
        public Object next() {
            try {
                return JettisonProvider.jettisonUnwrap(this.jsonArray.get(this.index++));
            }
            catch (JSONException jsonException) {
                throw new NoSuchElementException(jsonException.toString());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class JettisonArray
    extends JSONArray
    implements Iterable<Object> {
        private static final long serialVersionUID = 2L;

        private JettisonArray(JettisonTokener tokener) throws JSONException {
            super((JSONTokener)tokener);
        }

        private JettisonArray() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new JettisonArrayIterator(this);
        }
    }

    private static class JettisonObject
    extends JSONObject
    implements Iterable<Object> {
        private static final long serialVersionUID = 1L;

        private JettisonObject(JettisonTokener tokener) throws JSONException {
            super((JSONTokener)tokener);
        }

        private JettisonObject() {
        }

        @Override
        public Iterator<Object> iterator() {
            return new JettisonObjectIterator(this);
        }
    }

    private static class JettisonTokener
    extends JSONTokener {
        public JettisonTokener(String s) {
            super(s);
        }

        protected JettisonObject newJSONObject() throws JSONException {
            return new JettisonObject(this);
        }

        protected JettisonArray newJSONArray() throws JSONException {
            return new JettisonArray(this);
        }
    }
}

