/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.netty.handler.ssl.SslHandler;
import java.util.function.Consumer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import reactor.netty.http.Http2SslContextSpec;
import reactor.netty.http.client.HttpClientConfig;
import reactor.netty.tcp.SslProvider;

final class HttpClientSecure {
    static final Consumer<? super SslHandler> DEFAULT_HOSTNAME_VERIFICATION;
    static final SslProvider HTTP2_SSL_PROVIDER;
    static final SslProvider DEFAULT_HTTP_SSL_PROVIDER;
    static final SslProvider DEFAULT_HTTP2_SSL_PROVIDER;

    private HttpClientSecure() {
    }

    static SslProvider defaultSslProvider(HttpClientConfig config) {
        if (config.checkProtocol(2)) {
            return DEFAULT_HTTP2_SSL_PROVIDER;
        }
        return DEFAULT_HTTP_SSL_PROVIDER;
    }

    static boolean hasDefaultSslProvider(HttpClientConfig config) {
        return DEFAULT_HTTP_SSL_PROVIDER == config.sslProvider || DEFAULT_HTTP2_SSL_PROVIDER == config.sslProvider;
    }

    static SslProvider sslProvider(SslProvider sslProvider) {
        return SslProvider.addHandlerConfigurator(sslProvider, DEFAULT_HOSTNAME_VERIFICATION);
    }

    static {
        SslProvider sslProvider;
        DEFAULT_HOSTNAME_VERIFICATION = handler -> {
            SSLEngine sslEngine = handler.engine();
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParameters);
        };
        try {
            sslProvider = SslProvider.builder().sslContext(Http2SslContextSpec.forClient()).build();
        }
        catch (Exception e) {
            sslProvider = null;
        }
        HTTP2_SSL_PROVIDER = sslProvider;
        DEFAULT_HTTP_SSL_PROVIDER = SslProvider.addHandlerConfigurator(SslProvider.defaultClientProvider(), DEFAULT_HOSTNAME_VERIFICATION);
        DEFAULT_HTTP2_SSL_PROVIDER = SslProvider.addHandlerConfigurator(HTTP2_SSL_PROVIDER, DEFAULT_HOSTNAME_VERIFICATION);
    }
}

