/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.AdminUriTemplate;
import com.github.tomakehurst.wiremock.admin.model.PathParams;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.google.common.base.Preconditions;

public class RequestSpec {
    private final RequestMethod method;
    private final AdminUriTemplate uriTemplate;

    public RequestSpec(RequestMethod method2, String uriTemplate) {
        Preconditions.checkNotNull(method2);
        Preconditions.checkNotNull(uriTemplate);
        this.method = method2;
        this.uriTemplate = new AdminUriTemplate(uriTemplate);
    }

    public static RequestSpec requestSpec(RequestMethod method2, String path2) {
        return new RequestSpec(method2, path2);
    }

    public RequestMethod method() {
        return this.method;
    }

    public AdminUriTemplate getUriTemplate() {
        return this.uriTemplate;
    }

    public String path() {
        return this.path(PathParams.empty());
    }

    public String path(PathParams pathParams) {
        return this.uriTemplate.render(pathParams);
    }

    public boolean matches(RequestMethod method2, String path2) {
        return (this.method.equals(RequestMethod.ANY) || this.method.equals(method2)) && this.uriTemplate.matches(path2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestSpec that = (RequestSpec)o;
        if (!this.method.equals(that.method)) {
            return false;
        }
        return this.uriTemplate.equals(that.uriTemplate);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.uriTemplate.hashCode();
        return result;
    }
}

