/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.math3.ode.EquationsMapper;
import org.apache.commons.math3.ode.sampling.AbstractStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

class GraggBulirschStoerStepInterpolator
extends AbstractStepInterpolator {
    private static final long serialVersionUID = 20110928L;
    private double[] y0Dot;
    private double[] y1;
    private double[] y1Dot;
    private double[][] yMidDots;
    private double[][] polynomials;
    private double[] errfac;
    private int currentDegree;

    public GraggBulirschStoerStepInterpolator() {
        this.y0Dot = null;
        this.y1 = null;
        this.y1Dot = null;
        this.yMidDots = null;
        this.resetTables(-1);
    }

    public GraggBulirschStoerStepInterpolator(double[] y, double[] y0Dot, double[] y1, double[] y1Dot, double[][] yMidDots, boolean forward, EquationsMapper primaryMapper, EquationsMapper[] secondaryMappers) {
        super(y, forward, primaryMapper, secondaryMappers);
        this.y0Dot = y0Dot;
        this.y1 = y1;
        this.y1Dot = y1Dot;
        this.yMidDots = yMidDots;
        this.resetTables(yMidDots.length + 4);
    }

    public GraggBulirschStoerStepInterpolator(GraggBulirschStoerStepInterpolator interpolator) {
        super(interpolator);
        int dimension = this.currentState.length;
        this.y0Dot = null;
        this.y1 = null;
        this.y1Dot = null;
        this.yMidDots = null;
        if (interpolator.polynomials == null) {
            this.polynomials = null;
            this.currentDegree = -1;
        } else {
            this.resetTables(interpolator.currentDegree);
            for (int i2 = 0; i2 < this.polynomials.length; ++i2) {
                this.polynomials[i2] = new double[dimension];
                System.arraycopy(interpolator.polynomials[i2], 0, this.polynomials[i2], 0, dimension);
            }
            this.currentDegree = interpolator.currentDegree;
        }
    }

    private void resetTables(int maxDegree) {
        if (maxDegree < 0) {
            this.polynomials = null;
            this.errfac = null;
            this.currentDegree = -1;
        } else {
            int i2;
            double[][] newPols = new double[maxDegree + 1][];
            if (this.polynomials != null) {
                System.arraycopy(this.polynomials, 0, newPols, 0, this.polynomials.length);
                for (i2 = this.polynomials.length; i2 < newPols.length; ++i2) {
                    newPols[i2] = new double[this.currentState.length];
                }
            } else {
                for (i2 = 0; i2 < newPols.length; ++i2) {
                    newPols[i2] = new double[this.currentState.length];
                }
            }
            this.polynomials = newPols;
            if (maxDegree <= 4) {
                this.errfac = null;
            } else {
                this.errfac = new double[maxDegree - 4];
                for (i2 = 0; i2 < this.errfac.length; ++i2) {
                    int ip5 = i2 + 5;
                    this.errfac[i2] = 1.0 / (double)(ip5 * ip5);
                    double e = 0.5 * FastMath.sqrt((double)(i2 + 1) / (double)ip5);
                    for (int j = 0; j <= i2; ++j) {
                        int n = i2;
                        this.errfac[n] = this.errfac[n] * (e / (double)(j + 1));
                    }
                }
            }
            this.currentDegree = 0;
        }
    }

    protected StepInterpolator doCopy() {
        return new GraggBulirschStoerStepInterpolator(this);
    }

    public void computeCoefficients(int mu, double h) {
        if (this.polynomials == null || this.polynomials.length <= mu + 4) {
            this.resetTables(mu + 4);
        }
        this.currentDegree = mu + 4;
        for (int i2 = 0; i2 < this.currentState.length; ++i2) {
            double yp0 = h * this.y0Dot[i2];
            double yp1 = h * this.y1Dot[i2];
            double ydiff = this.y1[i2] - this.currentState[i2];
            double aspl = ydiff - yp1;
            double bspl = yp0 - ydiff;
            this.polynomials[0][i2] = this.currentState[i2];
            this.polynomials[1][i2] = ydiff;
            this.polynomials[2][i2] = aspl;
            this.polynomials[3][i2] = bspl;
            if (mu < 0) {
                return;
            }
            double ph0 = 0.5 * (this.currentState[i2] + this.y1[i2]) + 0.125 * (aspl + bspl);
            this.polynomials[4][i2] = 16.0 * (this.yMidDots[0][i2] - ph0);
            if (mu <= 0) continue;
            double ph1 = ydiff + 0.25 * (aspl - bspl);
            this.polynomials[5][i2] = 16.0 * (this.yMidDots[1][i2] - ph1);
            if (mu <= 1) continue;
            double ph2 = yp1 - yp0;
            this.polynomials[6][i2] = 16.0 * (this.yMidDots[2][i2] - ph2 + this.polynomials[4][i2]);
            if (mu <= 2) continue;
            double ph3 = 6.0 * (bspl - aspl);
            this.polynomials[7][i2] = 16.0 * (this.yMidDots[3][i2] - ph3 + 3.0 * this.polynomials[5][i2]);
            for (int j = 4; j <= mu; ++j) {
                double fac1 = 0.5 * (double)j * (double)(j - 1);
                double fac2 = 2.0 * fac1 * (double)(j - 2) * (double)(j - 3);
                this.polynomials[j + 4][i2] = 16.0 * (this.yMidDots[j][i2] + fac1 * this.polynomials[j + 2][i2] - fac2 * this.polynomials[j][i2]);
            }
        }
    }

    public double estimateError(double[] scale) {
        double error = 0.0;
        if (this.currentDegree >= 5) {
            for (int i2 = 0; i2 < scale.length; ++i2) {
                double e = this.polynomials[this.currentDegree][i2] / scale[i2];
                error += e * e;
            }
            error = FastMath.sqrt(error / (double)scale.length) * this.errfac[this.currentDegree - 5];
        }
        return error;
    }

    protected void computeInterpolatedStateAndDerivatives(double theta, double oneMinusThetaH) {
        int dimension = this.currentState.length;
        double oneMinusTheta = 1.0 - theta;
        double theta05 = theta - 0.5;
        double tOmT = theta * oneMinusTheta;
        double t4 = tOmT * tOmT;
        double t4Dot = 2.0 * tOmT * (1.0 - 2.0 * theta);
        double dot1 = 1.0 / this.h;
        double dot2 = theta * (2.0 - 3.0 * theta) / this.h;
        double dot3 = ((3.0 * theta - 4.0) * theta + 1.0) / this.h;
        for (int i2 = 0; i2 < dimension; ++i2) {
            double p0 = this.polynomials[0][i2];
            double p1 = this.polynomials[1][i2];
            double p2 = this.polynomials[2][i2];
            double p3 = this.polynomials[3][i2];
            this.interpolatedState[i2] = p0 + theta * (p1 + oneMinusTheta * (p2 * theta + p3 * oneMinusTheta));
            this.interpolatedDerivatives[i2] = dot1 * p1 + dot2 * p2 + dot3 * p3;
            if (this.currentDegree <= 3) continue;
            double cDot = 0.0;
            double c = this.polynomials[this.currentDegree][i2];
            for (int j = this.currentDegree - 1; j > 3; --j) {
                double d = 1.0 / (double)(j - 3);
                cDot = d * (theta05 * cDot + c);
                c = this.polynomials[j][i2] + c * d * theta05;
            }
            int n = i2;
            this.interpolatedState[n] = this.interpolatedState[n] + t4 * c;
            int n2 = i2;
            this.interpolatedDerivatives[n2] = this.interpolatedDerivatives[n2] + (t4 * cDot + t4Dot * c) / this.h;
        }
        if (this.h == 0.0) {
            System.arraycopy(this.yMidDots[1], 0, this.interpolatedDerivatives, 0, dimension);
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        int dimension = this.currentState == null ? -1 : this.currentState.length;
        this.writeBaseExternal(out);
        out.writeInt(this.currentDegree);
        for (int k = 0; k <= this.currentDegree; ++k) {
            for (int l = 0; l < dimension; ++l) {
                out.writeDouble(this.polynomials[k][l]);
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        double t = this.readBaseExternal(in);
        int dimension = this.currentState == null ? -1 : this.currentState.length;
        int degree = in.readInt();
        this.resetTables(degree);
        this.currentDegree = degree;
        for (int k = 0; k <= this.currentDegree; ++k) {
            for (int l = 0; l < dimension; ++l) {
                this.polynomials[k][l] = in.readDouble();
            }
        }
        this.setInterpolatedTime(t);
    }
}

