/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.extension.responsetemplating.helpers;

import com.github.jknack.handlebars.Helper;
import com.github.jknack.handlebars.Options;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.Base64Helper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.FormDataHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsCurrentDateHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsJsonPathHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsRandomValuesHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsSoapHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HandlebarsXPathHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.HostnameHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.ParseDateHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.RegexExtractHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.SizeHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.StringTrimHelper;
import com.github.tomakehurst.wiremock.extension.responsetemplating.helpers.UrlEncodingHelper;
import java.io.IOException;
import java.util.Date;

public enum WireMockHelpers implements Helper<Object>
{
    xPath{
        private HandlebarsXPathHelper helper = new HandlebarsXPathHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(String.valueOf(context), options);
        }
    }
    ,
    soapXPath{
        private HandlebarsSoapHelper helper = new HandlebarsSoapHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(String.valueOf(context), options);
        }
    }
    ,
    jsonPath{
        private HandlebarsJsonPathHelper helper = new HandlebarsJsonPathHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    randomValue{
        private HandlebarsRandomValuesHelper helper = new HandlebarsRandomValuesHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(null, options);
        }
    }
    ,
    hostname{
        private HostnameHelper helper = new HostnameHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    date{
        private HandlebarsCurrentDateHelper helper = new HandlebarsCurrentDateHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            Date dateContext = context instanceof Date ? (Date)context : null;
            return this.helper.apply(dateContext, options);
        }
    }
    ,
    now{
        private HandlebarsCurrentDateHelper helper = new HandlebarsCurrentDateHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(null, options);
        }
    }
    ,
    parseDate{
        private ParseDateHelper helper = new ParseDateHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context.toString(), options);
        }
    }
    ,
    trim{
        private StringTrimHelper helper = new StringTrimHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    base64{
        private Base64Helper helper = new Base64Helper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    urlEncode{
        private UrlEncodingHelper helper = new UrlEncodingHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    formData{
        private FormDataHelper helper = new FormDataHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    regexExtract{
        private RegexExtractHelper helper = new RegexExtractHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    }
    ,
    size{
        private SizeHelper helper = new SizeHelper();

        @Override
        public Object apply(Object context, Options options) throws IOException {
            return this.helper.apply(context, options);
        }
    };

}

