/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpRequestInterceptor;
import reactivefeign.utils.MultiValueMapUtils;
import reactivefeign.utils.Pair;
import reactor.core.publisher.Mono;

public final class ReactiveHttpRequestInterceptors {
    private ReactiveHttpRequestInterceptors() {
    }

    public static ReactiveHttpRequestInterceptor addHeader(String header, String value) {
        return ReactiveHttpRequestInterceptors.addHeaders(Collections.singletonList(new Pair<String, String>(header, value)));
    }

    public static ReactiveHttpRequestInterceptor addHeaders(List<Pair<String, String>> headers2) {
        return ReactiveHttpRequestInterceptors.from(request -> {
            headers2.forEach(header -> MultiValueMapUtils.addOrdered(request.headers(), (String)header.left, (String)header.right));
            return request;
        });
    }

    public static ReactiveHttpRequestInterceptor from(Function<ReactiveHttpRequest, ReactiveHttpRequest> function) {
        return request -> Mono.just((ReactiveHttpRequest)function.apply((ReactiveHttpRequest)request));
    }
}

