/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.matching;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.matching.AbsentPattern;
import com.github.tomakehurst.wiremock.matching.BinaryEqualToPattern;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePatternJsonDeserializer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Map;

public class ContentPatternDeserialiser
extends JsonDeserializer<ContentPattern<?>> {
    @Override
    public ContentPattern<?> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        JsonNode rootNode = (JsonNode)parser.readValueAsTree();
        if (ContentPatternDeserialiser.isAbsent(rootNode)) {
            return AbsentPattern.ABSENT;
        }
        if (!rootNode.has("binaryEqualTo")) {
            return new StringValuePatternJsonDeserializer().buildStringValuePattern(rootNode);
        }
        return this.deserializeBinaryEqualTo(rootNode);
    }

    private BinaryEqualToPattern deserializeBinaryEqualTo(JsonNode rootNode) throws JsonMappingException {
        String operand = rootNode.findValue("binaryEqualTo").textValue();
        return new BinaryEqualToPattern(operand);
    }

    private static boolean isAbsent(JsonNode rootNode) {
        for (Map.Entry entry : ImmutableList.copyOf(rootNode.fields())) {
            if (!((String)entry.getKey()).equals("absent")) continue;
            return true;
        }
        return false;
    }
}

