/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.DatagramChannel;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.Nullable;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.resources.LoopResources;
import reactor.util.Logger;
import reactor.util.Loggers;

public class UdpResources
implements LoopResources {
    final LoopResources defaultLoops;
    static final Logger log = Loggers.getLogger(UdpResources.class);
    static final AtomicReference<UdpResources> udpResources;
    static final Function<LoopResources, UdpResources> ON_UDP_NEW;
    static final int DEFAULT_UDP_THREAD_COUNT;

    public static UdpResources get() {
        return UdpResources.getOrCreate(null, ON_UDP_NEW, "udp");
    }

    public static UdpResources set(LoopResources loops) {
        return UdpResources.getOrCreate(loops, ON_UDP_NEW, "udp");
    }

    public static UdpResources reset() {
        UdpResources.shutdown();
        return UdpResources.getOrCreate(null, ON_UDP_NEW, "udp");
    }

    public static void shutdown() {
        UdpResources resources2 = udpResources.getAndSet(null);
        if (resources2 != null) {
            resources2._dispose();
        }
    }

    public static Mono<Void> shutdownLater() {
        return UdpResources.shutdownLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    public static Mono<Void> shutdownLater(Duration quietPeriod, Duration timeout) {
        return Mono.defer(() -> {
            UdpResources resources2 = udpResources.getAndSet(null);
            if (resources2 != null) {
                return resources2._disposeLater(quietPeriod, timeout);
            }
            return Mono.empty();
        });
    }

    protected UdpResources(LoopResources defaultLoops) {
        this.defaultLoops = defaultLoops;
    }

    protected void _dispose() {
        this.defaultLoops.dispose();
    }

    @Deprecated
    protected Mono<Void> _disposeLater() {
        return this._disposeLater(Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_QUIET_PERIOD), Duration.ofSeconds(LoopResources.DEFAULT_SHUTDOWN_TIMEOUT));
    }

    protected Mono<Void> _disposeLater(Duration quietPeriod, Duration timeout) {
        return this.defaultLoops.disposeLater(quietPeriod, timeout);
    }

    @Override
    public boolean isDisposed() {
        return this.defaultLoops.isDisposed();
    }

    @Override
    public Class<? extends Channel> onChannel(EventLoopGroup group) {
        return this.defaultLoops.onChannel(group);
    }

    @Override
    public EventLoopGroup onClient(boolean useNative) {
        return this.defaultLoops.onClient(useNative);
    }

    @Override
    public Class<? extends DatagramChannel> onDatagramChannel(EventLoopGroup group) {
        return this.defaultLoops.onDatagramChannel(group);
    }

    @Override
    public EventLoopGroup onServer(boolean useNative) {
        return this.defaultLoops.onServer(useNative);
    }

    @Override
    public Class<? extends ServerChannel> onServerChannel(EventLoopGroup group) {
        return this.defaultLoops.onServerChannel(group);
    }

    @Override
    public EventLoopGroup onServerSelect(boolean useNative) {
        return this.defaultLoops.onServerSelect(useNative);
    }

    @Override
    public boolean preferNative() {
        return this.defaultLoops.preferNative();
    }

    @Override
    public boolean daemon() {
        return this.defaultLoops.daemon();
    }

    protected static UdpResources getOrCreate(@Nullable LoopResources loops, Function<LoopResources, UdpResources> onNew, String name) {
        UdpResources resources2;
        while ((resources2 = udpResources.get()) == null || loops != null) {
            UdpResources update = UdpResources.create(resources2, loops, name, onNew);
            if (udpResources.compareAndSet(resources2, update)) {
                if (resources2 != null) {
                    if (log.isWarnEnabled()) {
                        log.warn("[{}] resources will use a new LoopResources: {},the previous LoopResources will be disposed", name, loops);
                    }
                    resources2.defaultLoops.dispose();
                } else {
                    String loopType;
                    String string = loopType = loops == null ? "default" : "provided";
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] resources will use the {} LoopResources: {}", name, loopType, update.defaultLoops);
                    }
                }
                return update;
            }
            update._dispose();
        }
        return resources2;
    }

    static <T extends UdpResources> T create(@Nullable T previous, @Nullable LoopResources loops, String name, Function<LoopResources, T> onNew) {
        loops = previous == null ? (loops == null ? LoopResources.create(name, DEFAULT_UDP_THREAD_COUNT, true) : loops) : (loops == null ? previous.defaultLoops : loops);
        return (T)((UdpResources)onNew.apply(loops));
    }

    static {
        DEFAULT_UDP_THREAD_COUNT = Integer.parseInt(System.getProperty("reactor.netty.udp.ioThreadCount", "" + Schedulers.DEFAULT_POOL_SIZE));
        ON_UDP_NEW = UdpResources::new;
        udpResources = new AtomicReference();
    }
}

