/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.AbstractAsyncClientHttpRequest;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.Netty4ClientHttpResponse;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

@Deprecated
class Netty4ClientHttpRequest
extends AbstractAsyncClientHttpRequest
implements ClientHttpRequest {
    private final Bootstrap bootstrap;
    private final URI uri;
    private final HttpMethod method;
    private final ByteBufOutputStream body;

    public Netty4ClientHttpRequest(Bootstrap bootstrap, URI uri, HttpMethod method2) {
        this.bootstrap = bootstrap;
        this.uri = uri;
        this.method = method2;
        this.body = new ByteBufOutputStream(Unpooled.buffer(1024));
    }

    @Override
    public HttpMethod getMethod() {
        return this.method;
    }

    @Override
    public String getMethodValue() {
        return this.method.name();
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public ClientHttpResponse execute() throws IOException {
        try {
            return (ClientHttpResponse)this.executeAsync().get();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new IOException("Interrupted during request execution", ex);
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof IOException) {
                throw (IOException)ex.getCause();
            }
            throw new IOException(ex.getMessage(), ex.getCause());
        }
    }

    @Override
    protected OutputStream getBodyInternal(HttpHeaders headers2) throws IOException {
        return this.body;
    }

    @Override
    protected ListenableFuture<ClientHttpResponse> executeInternal(HttpHeaders headers2) throws IOException {
        SettableListenableFuture<ClientHttpResponse> responseFuture = new SettableListenableFuture<ClientHttpResponse>();
        ChannelFutureListener connectionListener = future -> {
            if (future.isSuccess()) {
                Channel channel = future.channel();
                channel.pipeline().addLast(new RequestExecuteHandler(responseFuture));
                FullHttpRequest nettyRequest = this.createFullHttpRequest(headers2);
                channel.writeAndFlush(nettyRequest);
            } else {
                responseFuture.setException(future.cause());
            }
        };
        this.bootstrap.connect(this.uri.getHost(), Netty4ClientHttpRequest.getPort(this.uri)).addListener(connectionListener);
        return responseFuture;
    }

    private FullHttpRequest createFullHttpRequest(HttpHeaders headers2) {
        io.netty.handler.codec.http.HttpMethod nettyMethod = io.netty.handler.codec.http.HttpMethod.valueOf(this.method.name());
        String authority = this.uri.getRawAuthority();
        String path2 = this.uri.toString().substring(this.uri.toString().indexOf(authority) + authority.length());
        DefaultFullHttpRequest nettyRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, nettyMethod, path2, this.body.buffer());
        nettyRequest.headers().set("Host", (Object)(this.uri.getHost() + ":" + Netty4ClientHttpRequest.getPort(this.uri)));
        nettyRequest.headers().set("Connection", (Object)"close");
        headers2.forEach((headerName, headerValues) -> nettyRequest.headers().add((String)headerName, (Iterable<?>)headerValues));
        if (!nettyRequest.headers().contains("Content-Length") && this.body.buffer().readableBytes() > 0) {
            nettyRequest.headers().set("Content-Length", (Object)this.body.buffer().readableBytes());
        }
        return nettyRequest;
    }

    private static int getPort(URI uri) {
        int port = uri.getPort();
        if (port == -1) {
            if ("http".equalsIgnoreCase(uri.getScheme())) {
                port = 80;
            } else if ("https".equalsIgnoreCase(uri.getScheme())) {
                port = 443;
            }
        }
        return port;
    }

    private static class RequestExecuteHandler
    extends SimpleChannelInboundHandler<FullHttpResponse> {
        private final SettableListenableFuture<ClientHttpResponse> responseFuture;

        public RequestExecuteHandler(SettableListenableFuture<ClientHttpResponse> responseFuture) {
            this.responseFuture = responseFuture;
        }

        @Override
        protected void channelRead0(ChannelHandlerContext context, FullHttpResponse response) throws Exception {
            this.responseFuture.set(new Netty4ClientHttpResponse(context, response));
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) throws Exception {
            this.responseFuture.setException(cause);
        }
    }
}

