/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.generators.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openjdk.jmh.generators.core.GeneratorDestination;
import org.openjdk.jmh.generators.core.MetadataInfo;
import org.openjdk.jmh.generators.core.SourceElementError;
import org.openjdk.jmh.generators.core.SourceElementWarning;
import org.openjdk.jmh.generators.core.SourceError;
import org.openjdk.jmh.generators.core.SourceThrowableError;
import org.openjdk.jmh.generators.core.SourceThrowableWarning;
import org.openjdk.jmh.generators.core.SourceWarning;

public class FileSystemDestination
implements GeneratorDestination {
    private final File resourceDir;
    private final File sourceDir;
    private final List<SourceError> sourceErrors;
    private final List<SourceWarning> sourceWarnings;

    public FileSystemDestination(File resourceDir, File sourceDir) {
        this.resourceDir = resourceDir;
        this.sourceDir = sourceDir;
        this.sourceErrors = new ArrayList<SourceError>();
        this.sourceWarnings = new ArrayList<SourceWarning>();
    }

    @Override
    public OutputStream newResource(String resourcePath) throws IOException {
        String pathName = this.resourceDir.getAbsolutePath() + "/" + resourcePath;
        File p = new File(pathName.substring(0, pathName.lastIndexOf("/")));
        if (!p.mkdirs() && !p.isDirectory()) {
            throw new IOException("Unable to create " + p.getAbsolutePath());
        }
        return new FileOutputStream(new File(pathName));
    }

    @Override
    public InputStream getResource(String resourcePath) throws IOException {
        String pathName = this.resourceDir.getAbsolutePath() + "/" + resourcePath;
        File p = new File(pathName.substring(0, pathName.lastIndexOf("/")));
        if (!p.isFile() && !p.exists()) {
            throw new IOException("Unable to open " + pathName);
        }
        return new FileInputStream(new File(pathName));
    }

    @Override
    public Writer newClass(String className) throws IOException {
        String pathName = this.sourceDir.getAbsolutePath() + "/" + className.replaceAll("\\.", "/");
        File p = new File(pathName.substring(0, pathName.lastIndexOf("/")));
        if (!p.mkdirs() && !p.isDirectory()) {
            throw new IOException("Unable to create " + p.getAbsolutePath());
        }
        return new FileWriter(new File(pathName + ".java"));
    }

    @Override
    public void printError(String message) {
        this.sourceErrors.add(new SourceError(message));
    }

    @Override
    public void printError(String message, MetadataInfo element) {
        this.sourceErrors.add(new SourceElementError(message, element));
    }

    @Override
    public void printError(String message, Throwable throwable) {
        this.sourceErrors.add(new SourceThrowableError(message, throwable));
    }

    public boolean hasErrors() {
        return !this.sourceErrors.isEmpty();
    }

    public Collection<SourceError> getErrors() {
        return this.sourceErrors;
    }

    @Override
    public void printWarning(String message) {
        this.sourceWarnings.add(new SourceWarning(message));
    }

    @Override
    public void printWarning(String message, MetadataInfo element) {
        this.sourceWarnings.add(new SourceElementWarning(message, element));
    }

    @Override
    public void printWarning(String message, Throwable throwable) {
        this.sourceWarnings.add(new SourceThrowableWarning(message, throwable));
    }

    public boolean hasWarnings() {
        return !this.sourceWarnings.isEmpty();
    }

    public Collection<SourceWarning> getWarnings() {
        return this.sourceWarnings;
    }

    @Override
    public void printNote(String message) {
    }
}

