/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client;

import io.reactivex.netty.client.ClientMetricsEvent;
import io.reactivex.netty.protocol.http.client.CompositeHttpClientBuilder;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class MaxConnectionsBasedStrategy
implements CompositeHttpClientBuilder.CloneablePoolLimitDeterminationStrategy {
    public static final int DEFAULT_MAX_CONNECTIONS = 1000;
    private final AtomicInteger limitEnforcer;
    private final AtomicInteger maxConnections;
    private final int originalMaxConnLimit;

    public MaxConnectionsBasedStrategy() {
        this(1000);
    }

    public MaxConnectionsBasedStrategy(int maxConnections) {
        this.maxConnections = new AtomicInteger(maxConnections);
        this.limitEnforcer = new AtomicInteger();
        this.originalMaxConnLimit = maxConnections;
    }

    @Override
    public boolean acquireCreationPermit(long acquireStartTime, TimeUnit timeUnit) {
        int maxAllowedConnections;
        int currentValue;
        int newValue;
        while ((newValue = (currentValue = this.limitEnforcer.get()) + 1) <= (maxAllowedConnections = this.maxConnections.get())) {
            if (!this.limitEnforcer.compareAndSet(currentValue, newValue)) continue;
            return true;
        }
        return false;
    }

    public int incrementMaxConnections(int incrementBy) {
        return this.maxConnections.addAndGet(incrementBy);
    }

    public int decrementMaxConnections(int decrementBy) {
        return this.maxConnections.addAndGet(-1 * decrementBy);
    }

    public int getMaxConnections() {
        return this.maxConnections.get();
    }

    @Override
    public int getAvailablePermits() {
        return this.maxConnections.get() - this.limitEnforcer.get();
    }

    private void onConnectFailed() {
        this.limitEnforcer.decrementAndGet();
    }

    private void onConnectionEviction() {
        this.limitEnforcer.decrementAndGet();
    }

    @Override
    public CompositeHttpClientBuilder.CloneablePoolLimitDeterminationStrategy copy() {
        return new MaxConnectionsBasedStrategy(this.originalMaxConnLimit);
    }

    @Override
    public void onEvent(ClientMetricsEvent<?> event, long duration, TimeUnit timeUnit, Throwable throwable, Object value) {
        if (event.getType() instanceof ClientMetricsEvent.EventType) {
            switch ((ClientMetricsEvent.EventType)event.getType()) {
                case ConnectStart: {
                    break;
                }
                case ConnectSuccess: {
                    break;
                }
                case ConnectFailed: {
                    this.onConnectFailed();
                    break;
                }
                case PooledConnectionReuse: {
                    break;
                }
                case PooledConnectionEviction: {
                    this.onConnectionEviction();
                    break;
                }
                case ConnectionCloseStart: {
                    break;
                }
                case ConnectionCloseSuccess: {
                    break;
                }
            }
        }
    }

    @Override
    public void onCompleted() {
    }

    @Override
    public void onSubscribe() {
    }
}

