/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.Gzip;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.http.CaseInsensitiveKey;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.LoggedResponse;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.nio.charset.Charset;
import java.util.List;

public class LoggedResponseDefinitionTransformer
implements Function<LoggedResponse, ResponseDefinition> {
    private static final List<CaseInsensitiveKey> EXCLUDED_HEADERS = ImmutableList.of(CaseInsensitiveKey.from("Content-Encoding"), CaseInsensitiveKey.from("Content-Length"), CaseInsensitiveKey.from("Transfer-Encoding"));

    @Override
    public ResponseDefinition apply(LoggedResponse response) {
        ResponseDefinitionBuilder responseDefinitionBuilder = new ResponseDefinitionBuilder().withStatus(response.getStatus());
        if (response.getBody() != null && response.getBody().length > 0) {
            byte[] body2 = this.bodyDecompressedIfRequired(response);
            String mimeType = response.getMimeType();
            Charset charset = response.getCharset();
            if (ContentTypes.determineIsTextFromMimeType(mimeType)) {
                responseDefinitionBuilder.withBody(Strings.stringFromBytes(body2, charset));
            } else {
                responseDefinitionBuilder.withBody(body2);
            }
        }
        if (response.getHeaders() != null) {
            responseDefinitionBuilder.withHeaders(this.withoutContentEncodingAndContentLength(response));
        }
        return responseDefinitionBuilder.build();
    }

    private byte[] bodyDecompressedIfRequired(LoggedResponse response) {
        if (response.getHeaders().getHeader("Content-Encoding").containsValue("gzip")) {
            return Gzip.unGzip(response.getBody());
        }
        return response.getBody();
    }

    private HttpHeaders withoutContentEncodingAndContentLength(LoggedResponse response) {
        return new HttpHeaders(Iterables.filter(response.getHeaders().all(), new Predicate<HttpHeader>(){

            @Override
            public boolean apply(HttpHeader header) {
                return !EXCLUDED_HEADERS.contains(header.caseInsensitiveKey());
            }
        }));
    }
}

