/*
 * Decompiled with CFR 0.152.
 */
package com.flipkart.zjsonpatch;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.flipkart.zjsonpatch.Diff;
import com.flipkart.zjsonpatch.DiffFlags;
import com.flipkart.zjsonpatch.InternalUtils;
import com.flipkart.zjsonpatch.NodeType;
import com.flipkart.zjsonpatch.Operation;
import com.flipkart.zjsonpatch.PathUtils;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class JsonDiff {
    private JsonDiff() {
    }

    public static JsonNode asJson(JsonNode source, JsonNode target) {
        return JsonDiff.asJson(source, target, DiffFlags.defaults());
    }

    public static JsonNode asJson(JsonNode source, JsonNode target, EnumSet<DiffFlags> flags) {
        ArrayList<Diff> diffs = new ArrayList<Diff>();
        ArrayList<Object> path2 = new ArrayList<Object>(0);
        JsonDiff.generateDiffs(diffs, path2, source, target);
        if (!flags.contains((Object)DiffFlags.OMIT_MOVE_OPERATION)) {
            JsonDiff.compactDiffs(diffs);
        }
        if (!flags.contains((Object)DiffFlags.OMIT_COPY_OPERATION)) {
            JsonDiff.introduceCopyOperation(source, target, diffs);
        }
        return JsonDiff.getJsonNodes(diffs, flags);
    }

    private static List<Object> getMatchingValuePath(Map<JsonNode, List<Object>> unchangedValues, JsonNode value) {
        return unchangedValues.get(value);
    }

    private static void introduceCopyOperation(JsonNode source, JsonNode target, List<Diff> diffs) {
        Map<JsonNode, List<Object>> unchangedValues = JsonDiff.getUnchangedPart(source, target);
        for (int i2 = 0; i2 < diffs.size(); ++i2) {
            List<Object> matchingValuePath;
            Diff diff = diffs.get(i2);
            if (Operation.ADD != diff.getOperation() || (matchingValuePath = JsonDiff.getMatchingValuePath(unchangedValues, diff.getValue())) == null || !JsonDiff.isAllowed(matchingValuePath, diff.getPath())) continue;
            diffs.set(i2, new Diff(Operation.COPY, matchingValuePath, diff.getPath()));
        }
    }

    private static boolean isNumber(String str) {
        int size = str.length();
        for (int i2 = 0; i2 < size; ++i2) {
            if (Character.isDigit(str.charAt(i2))) continue;
            return false;
        }
        return size > 0;
    }

    private static boolean isAllowed(List<Object> source, List<Object> destination) {
        boolean isSame = source.equals(destination);
        int i2 = 0;
        for (int j = 0; i2 < source.size() && j < destination.size(); ++i2, ++j) {
            Object srcValue = source.get(i2);
            Object dstValue = destination.get(j);
            String srcStr = srcValue.toString();
            String dstStr = dstValue.toString();
            if (!JsonDiff.isNumber(srcStr) || !JsonDiff.isNumber(dstStr) || srcStr.compareTo(dstStr) <= 0) continue;
            return false;
        }
        return !isSame;
    }

    private static Map<JsonNode, List<Object>> getUnchangedPart(JsonNode source, JsonNode target) {
        HashMap<JsonNode, List<Object>> unchangedValues = new HashMap<JsonNode, List<Object>>();
        JsonDiff.computeUnchangedValues(unchangedValues, new ArrayList<Object>(), source, target);
        return unchangedValues;
    }

    private static void computeUnchangedValues(Map<JsonNode, List<Object>> unchangedValues, List<Object> path2, JsonNode source, JsonNode target) {
        NodeType secondType;
        if (source.equals(target)) {
            if (!unchangedValues.containsKey(target)) {
                unchangedValues.put(target, path2);
            }
            return;
        }
        NodeType firstType = NodeType.getNodeType(source);
        if (firstType == (secondType = NodeType.getNodeType(target))) {
            switch (firstType) {
                case OBJECT: {
                    JsonDiff.computeObject(unchangedValues, path2, source, target);
                    break;
                }
                case ARRAY: {
                    JsonDiff.computeArray(unchangedValues, path2, source, target);
                    break;
                }
            }
        }
    }

    private static void computeArray(Map<JsonNode, List<Object>> unchangedValues, List<Object> path2, JsonNode source, JsonNode target) {
        int size = Math.min(source.size(), target.size());
        for (int i2 = 0; i2 < size; ++i2) {
            List<Object> currPath = JsonDiff.getPath(path2, i2);
            JsonDiff.computeUnchangedValues(unchangedValues, currPath, source.get(i2), target.get(i2));
        }
    }

    private static void computeObject(Map<JsonNode, List<Object>> unchangedValues, List<Object> path2, JsonNode source, JsonNode target) {
        Iterator<String> firstFields = source.fieldNames();
        while (firstFields.hasNext()) {
            String name = firstFields.next();
            if (!target.has(name)) continue;
            List<Object> currPath = JsonDiff.getPath(path2, name);
            JsonDiff.computeUnchangedValues(unchangedValues, currPath, source.get(name), target.get(name));
        }
    }

    private static void compactDiffs(List<Diff> diffs) {
        block0: for (int i2 = 0; i2 < diffs.size(); ++i2) {
            Diff diff1 = diffs.get(i2);
            if (Operation.REMOVE != diff1.getOperation() && Operation.ADD != diff1.getOperation()) continue;
            for (int j = i2 + 1; j < diffs.size(); ++j) {
                Diff diff2 = diffs.get(j);
                if (!diff1.getValue().equals(diff2.getValue())) continue;
                Diff moveDiff = null;
                if (Operation.REMOVE == diff1.getOperation() && Operation.ADD == diff2.getOperation()) {
                    JsonDiff.computeRelativePath(diff2.getPath(), i2 + 1, j - 1, diffs);
                    moveDiff = new Diff(Operation.MOVE, diff1.getPath(), diff2.getPath());
                } else if (Operation.ADD == diff1.getOperation() && Operation.REMOVE == diff2.getOperation()) {
                    JsonDiff.computeRelativePath(diff2.getPath(), i2, j - 1, diffs);
                    moveDiff = new Diff(Operation.MOVE, diff2.getPath(), diff1.getPath());
                }
                if (moveDiff == null) continue;
                diffs.remove(j);
                diffs.set(i2, moveDiff);
                continue block0;
            }
        }
    }

    private static void computeRelativePath(List<Object> path2, int startIdx, int endIdx, List<Diff> diffs) {
        ArrayList<Integer> counters = new ArrayList<Integer>(path2.size());
        JsonDiff.resetCounters(counters, path2.size());
        for (int i2 = startIdx; i2 <= endIdx; ++i2) {
            Diff diff = diffs.get(i2);
            if (Operation.ADD != diff.getOperation() && Operation.REMOVE != diff.getOperation()) continue;
            JsonDiff.updatePath(path2, diff, counters);
        }
        JsonDiff.updatePathWithCounters(counters, path2);
    }

    private static void resetCounters(List<Integer> counters, int size) {
        for (int i2 = 0; i2 < size; ++i2) {
            counters.add(0);
        }
    }

    private static void updatePathWithCounters(List<Integer> counters, List<Object> path2) {
        for (int i2 = 0; i2 < counters.size(); ++i2) {
            int value = counters.get(i2);
            if (value == 0) continue;
            Integer currValue = Integer.parseInt(path2.get(i2).toString());
            path2.set(i2, String.valueOf(currValue + value));
        }
    }

    private static void updatePath(List<Object> path2, Diff pseudo, List<Integer> counters) {
        if (pseudo.getPath().size() <= path2.size()) {
            int idx = -1;
            int i2 = 0;
            while (i2 < pseudo.getPath().size() - 1 && pseudo.getPath().get(i2).equals(path2.get(i2))) {
                idx = i2++;
            }
            if (idx == pseudo.getPath().size() - 2 && pseudo.getPath().get(pseudo.getPath().size() - 1) instanceof Integer) {
                JsonDiff.updateCounters(pseudo, pseudo.getPath().size() - 1, counters);
            }
        }
    }

    private static void updateCounters(Diff pseudo, int idx, List<Integer> counters) {
        if (Operation.ADD == pseudo.getOperation()) {
            counters.set(idx, counters.get(idx) - 1);
        } else if (Operation.REMOVE == pseudo.getOperation()) {
            counters.set(idx, counters.get(idx) + 1);
        }
    }

    private static ArrayNode getJsonNodes(List<Diff> diffs, EnumSet<DiffFlags> flags) {
        JsonNodeFactory FACTORY = JsonNodeFactory.instance;
        ArrayNode patch = FACTORY.arrayNode();
        for (Diff diff : diffs) {
            ObjectNode jsonNode = JsonDiff.getJsonNode(FACTORY, diff, flags);
            patch.add(jsonNode);
        }
        return patch;
    }

    private static ObjectNode getJsonNode(JsonNodeFactory FACTORY, Diff diff, EnumSet<DiffFlags> flags) {
        ObjectNode jsonNode = FACTORY.objectNode();
        jsonNode.put("op", diff.getOperation().rfcName());
        switch (diff.getOperation()) {
            case MOVE: 
            case COPY: {
                jsonNode.put("from", PathUtils.getPathRepresentation(diff.getPath()));
                jsonNode.put("path", PathUtils.getPathRepresentation(diff.getToPath()));
                break;
            }
            case REMOVE: {
                jsonNode.put("path", PathUtils.getPathRepresentation(diff.getPath()));
                if (flags.contains((Object)DiffFlags.OMIT_VALUE_ON_REMOVE)) break;
                jsonNode.set("value", diff.getValue());
                break;
            }
            case REPLACE: {
                if (flags.contains((Object)DiffFlags.ADD_ORIGINAL_VALUE_ON_REPLACE)) {
                    jsonNode.set("fromValue", diff.getSrcValue());
                }
            }
            case ADD: 
            case TEST: {
                jsonNode.put("path", PathUtils.getPathRepresentation(diff.getPath()));
                jsonNode.set("value", diff.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operation specified:" + (Object)((Object)diff.getOperation()));
            }
        }
        return jsonNode;
    }

    private static void generateDiffs(List<Diff> diffs, List<Object> path2, JsonNode source, JsonNode target) {
        if (!source.equals(target)) {
            NodeType sourceType = NodeType.getNodeType(source);
            NodeType targetType = NodeType.getNodeType(target);
            if (sourceType == NodeType.ARRAY && targetType == NodeType.ARRAY) {
                JsonDiff.compareArray(diffs, path2, source, target);
            } else if (sourceType == NodeType.OBJECT && targetType == NodeType.OBJECT) {
                JsonDiff.compareObjects(diffs, path2, source, target);
            } else {
                diffs.add(Diff.generateDiff(Operation.REPLACE, path2, source, target));
            }
        }
    }

    private static void compareArray(List<Diff> diffs, List<Object> path2, JsonNode source, JsonNode target) {
        List<JsonNode> lcs = JsonDiff.getLCS(source, target);
        int srcIdx = 0;
        int targetIdx = 0;
        int lcsIdx = 0;
        int srcSize = source.size();
        int targetSize = target.size();
        int lcsSize = lcs.size();
        int pos = 0;
        while (lcsIdx < lcsSize) {
            List<Object> currPath;
            JsonNode lcsNode = lcs.get(lcsIdx);
            JsonNode srcNode = source.get(srcIdx);
            JsonNode targetNode = target.get(targetIdx);
            if (lcsNode.equals(srcNode) && lcsNode.equals(targetNode)) {
                ++srcIdx;
                ++targetIdx;
                ++lcsIdx;
                ++pos;
                continue;
            }
            if (lcsNode.equals(srcNode)) {
                currPath = JsonDiff.getPath(path2, pos);
                diffs.add(Diff.generateDiff(Operation.ADD, currPath, targetNode));
                ++pos;
                ++targetIdx;
                continue;
            }
            if (lcsNode.equals(targetNode)) {
                currPath = JsonDiff.getPath(path2, pos);
                diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, srcNode));
                ++srcIdx;
                continue;
            }
            currPath = JsonDiff.getPath(path2, pos);
            JsonDiff.generateDiffs(diffs, currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        while (srcIdx < srcSize && targetIdx < targetSize) {
            JsonNode srcNode = source.get(srcIdx);
            JsonNode targetNode = target.get(targetIdx);
            List<Object> currPath = JsonDiff.getPath(path2, pos);
            JsonDiff.generateDiffs(diffs, currPath, srcNode, targetNode);
            ++srcIdx;
            ++targetIdx;
            ++pos;
        }
        pos = JsonDiff.addRemaining(diffs, path2, target, pos, targetIdx, targetSize);
        JsonDiff.removeRemaining(diffs, path2, pos, srcIdx, srcSize, source);
    }

    private static Integer removeRemaining(List<Diff> diffs, List<Object> path2, int pos, int srcIdx, int srcSize, JsonNode source) {
        while (srcIdx < srcSize) {
            List<Object> currPath = JsonDiff.getPath(path2, pos);
            diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source.get(srcIdx)));
            ++srcIdx;
        }
        return pos;
    }

    private static Integer addRemaining(List<Diff> diffs, List<Object> path2, JsonNode target, int pos, int targetIdx, int targetSize) {
        while (targetIdx < targetSize) {
            JsonNode jsonNode = target.get(targetIdx);
            List<Object> currPath = JsonDiff.getPath(path2, pos);
            diffs.add(Diff.generateDiff(Operation.ADD, currPath, jsonNode.deepCopy()));
            ++pos;
            ++targetIdx;
        }
        return pos;
    }

    private static void compareObjects(List<Diff> diffs, List<Object> path2, JsonNode source, JsonNode target) {
        Iterator<String> keysFromSrc = source.fieldNames();
        while (keysFromSrc.hasNext()) {
            List<Object> currPath;
            String key = keysFromSrc.next();
            if (!target.has(key)) {
                currPath = JsonDiff.getPath(path2, key);
                diffs.add(Diff.generateDiff(Operation.REMOVE, currPath, source.get(key)));
                continue;
            }
            currPath = JsonDiff.getPath(path2, key);
            JsonDiff.generateDiffs(diffs, currPath, source.get(key), target.get(key));
        }
        Iterator<String> keysFromTarget = target.fieldNames();
        while (keysFromTarget.hasNext()) {
            String key = keysFromTarget.next();
            if (source.has(key)) continue;
            List<Object> currPath = JsonDiff.getPath(path2, key);
            diffs.add(Diff.generateDiff(Operation.ADD, currPath, target.get(key)));
        }
    }

    private static List<Object> getPath(List<Object> path2, Object key) {
        ArrayList<Object> toReturn = new ArrayList<Object>(path2.size() + 1);
        toReturn.addAll(path2);
        toReturn.add(key);
        return toReturn;
    }

    private static List<JsonNode> getLCS(JsonNode first, JsonNode second) {
        return InternalUtils.longestCommonSubsequence(InternalUtils.toList((ArrayNode)first), InternalUtils.toList((ArrayNode)second));
    }
}

