/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.utils;

import feign.Feign;
import feign.MethodMetadata;
import feign.Request;
import feign.Target;
import feign.Util;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactivefeign.client.ReactiveHttpResponse;
import reactor.core.publisher.Mono;

public class FeignUtils {
    public static String methodTag(MethodMetadata methodMetadata) {
        return methodMetadata.configKey().substring(0, methodMetadata.configKey().indexOf(40));
    }

    public static Class returnPublisherType(MethodMetadata methodMetadata) {
        return FeignUtils.returnPublisherType(methodMetadata.returnType());
    }

    public static boolean isResponsePublisher(Type returnType) {
        Class publisher = (Class)((ParameterizedType)returnType).getRawType();
        Type typeInPublisher = Util.resolveLastTypeParameter(returnType, publisher);
        return FeignUtils.isResponsePublisher(publisher, typeInPublisher);
    }

    public static Class returnPublisherType(Type returnType) {
        Type typeInPublisher;
        Class publisher = (Class)((ParameterizedType)returnType).getRawType();
        if (FeignUtils.isResponsePublisher(publisher, typeInPublisher = Util.resolveLastTypeParameter(returnType, publisher))) {
            Type typeInResponse = Util.resolveLastTypeParameter(typeInPublisher, ReactiveHttpResponse.class);
            return (Class)((ParameterizedType)typeInResponse).getRawType();
        }
        return publisher;
    }

    private static boolean isResponsePublisher(Class<?> publisher, Type typeInPublisher) {
        return publisher == Mono.class && typeInPublisher instanceof ParameterizedType && ((ParameterizedType)typeInPublisher).getRawType() == ReactiveHttpResponse.class;
    }

    public static Type returnActualType(MethodMetadata methodMetadata) {
        Type returnType = methodMetadata.returnType();
        return FeignUtils.returnActualType(returnType);
    }

    public static Type returnActualType(Type returnType) {
        Type typeInPublisher;
        Class publisher = (Class)((ParameterizedType)returnType).getRawType();
        if (FeignUtils.isResponsePublisher(publisher, typeInPublisher = Util.resolveLastTypeParameter(returnType, publisher))) {
            Type typeInResponse = Util.resolveLastTypeParameter(typeInPublisher, ReactiveHttpResponse.class);
            Class publisherInResponse = (Class)((ParameterizedType)typeInResponse).getRawType();
            return Util.resolveLastTypeParameter(typeInResponse, publisherInResponse);
        }
        return typeInPublisher;
    }

    public static Type bodyActualType(MethodMetadata methodMetadata) {
        return FeignUtils.getBodyActualType(methodMetadata.bodyType());
    }

    public static Type getBodyActualType(Type bodyType) {
        return Optional.ofNullable(bodyType).map(type -> {
            if (type instanceof ParameterizedType) {
                Class bodyClass = (Class)((ParameterizedType)type).getRawType();
                if (Publisher.class.isAssignableFrom(bodyClass)) {
                    return Util.resolveLastTypeParameter(bodyType, bodyClass);
                }
                return type;
            }
            return type;
        }).orElse(null);
    }

    public static Method findMethodInTarget(Target target, MethodMetadata methodMetadata) {
        return Arrays.stream(target.type().getMethods()).filter(method2 -> Feign.configKey(target.type(), method2).equals(methodMetadata.configKey())).findFirst().orElseThrow(IllegalArgumentException::new);
    }

    public static boolean requestWithBody(MethodMetadata methodMetadata) {
        return methodMetadata.bodyType() != null;
    }

    public static boolean responseWithBody(MethodMetadata methodMetadata) {
        return FeignUtils.returnActualType(methodMetadata) != Void.class;
    }

    public static Request.HttpMethod httpMethod(String method2) {
        return Request.HttpMethod.valueOf(method2.toUpperCase());
    }
}

