/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractListenerWebSocketSession;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class JettyWebSocketSession
extends AbstractListenerWebSocketSession<Session> {
    @Nullable
    private volatile SuspendToken suspendToken;

    public JettyWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory) {
        this(session, info, factory, null);
    }

    public JettyWebSocketSession(Session session, HandshakeInfo info, DataBufferFactory factory, @Nullable MonoProcessor<Void> completionMono) {
        super(session, ObjectUtils.getIdentityHexString(session), info, factory, completionMono);
    }

    @Override
    protected boolean canSuspendReceiving() {
        return true;
    }

    @Override
    protected void suspendReceiving() {
        Assert.state(this.suspendToken == null, "Already suspended");
        this.suspendToken = ((Session)this.getDelegate()).suspend();
    }

    @Override
    protected void resumeReceiving() {
        SuspendToken tokenToUse = this.suspendToken;
        this.suspendToken = null;
        if (tokenToUse != null) {
            tokenToUse.resume();
        }
    }

    @Override
    protected boolean sendMessage(WebSocketMessage message) throws IOException {
        ByteBuffer buffer = message.getPayload().asByteBuffer();
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            String text = new String(buffer.array(), StandardCharsets.UTF_8);
            ((Session)this.getDelegate()).getRemote().sendString(text, (WriteCallback)new SendProcessorCallback());
        } else if (WebSocketMessage.Type.BINARY.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            ((Session)this.getDelegate()).getRemote().sendBytes(buffer, (WriteCallback)new SendProcessorCallback());
        } else if (WebSocketMessage.Type.PING.equals((Object)message.getType())) {
            ((Session)this.getDelegate()).getRemote().sendPing(buffer);
        } else if (WebSocketMessage.Type.PONG.equals((Object)message.getType())) {
            ((Session)this.getDelegate()).getRemote().sendPong(buffer);
        } else {
            throw new IllegalArgumentException("Unexpected message type: " + (Object)((Object)message.getType()));
        }
        return true;
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        ((Session)this.getDelegate()).close(status.getCode(), status.getReason());
        return Mono.empty();
    }

    private final class SendProcessorCallback
    implements WriteCallback {
        private SendProcessorCallback() {
        }

        public void writeFailed(Throwable x) {
            JettyWebSocketSession.this.getSendProcessor().cancel();
            JettyWebSocketSession.this.getSendProcessor().onError(x);
        }

        public void writeSuccess() {
            JettyWebSocketSession.this.getSendProcessor().setReadyToSend(true);
            JettyWebSocketSession.this.getSendProcessor().onWritePossible();
        }
    }
}

