/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.lang.annotation.Annotation;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.ReactiveAdapter;
import org.springframework.core.ReactiveAdapterRegistry;
import org.springframework.util.Assert;
import org.springframework.web.reactive.result.method.HandlerMethodArgumentResolver;

public abstract class HandlerMethodArgumentResolverSupport
implements HandlerMethodArgumentResolver {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final ReactiveAdapterRegistry adapterRegistry;

    protected HandlerMethodArgumentResolverSupport(ReactiveAdapterRegistry adapterRegistry) {
        Assert.notNull((Object)adapterRegistry, "ReactiveAdapterRegistry is required");
        this.adapterRegistry = adapterRegistry;
    }

    public ReactiveAdapterRegistry getAdapterRegistry() {
        return this.adapterRegistry;
    }

    protected boolean checkParameterType(MethodParameter parameter, Predicate<Class<?>> predicate) {
        Class<?> type = parameter.getParameterType();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(type);
        if (adapter != null) {
            this.assertHasValues(adapter, parameter);
            type = parameter.nested().getNestedParameterType();
        }
        return predicate.test(type);
    }

    private void assertHasValues(ReactiveAdapter adapter, MethodParameter param) {
        if (adapter.isNoValue()) {
            throw new IllegalArgumentException("No value reactive types not supported: " + param.getGenericParameterType());
        }
    }

    protected boolean checkParameterTypeNoReactiveWrapper(MethodParameter parameter, Predicate<Class<?>> predicate) {
        Class<?> type = parameter.getParameterType();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(type);
        if (adapter != null) {
            this.assertHasValues(adapter, parameter);
            type = parameter.nested().getNestedParameterType();
        }
        if (predicate.test(type)) {
            if (adapter == null) {
                return true;
            }
            throw this.buildReactiveWrapperException(parameter);
        }
        return false;
    }

    private IllegalStateException buildReactiveWrapperException(MethodParameter parameter) {
        return new IllegalStateException(this.getClass().getSimpleName() + " does not support reactive type wrapper: " + parameter.getGenericParameterType());
    }

    protected <A extends Annotation> boolean checkAnnotatedParamNoReactiveWrapper(MethodParameter parameter, Class<A> annotationType, BiPredicate<A, Class<?>> typePredicate) {
        A annotation = parameter.getParameterAnnotation(annotationType);
        if (annotation == null) {
            return false;
        }
        parameter = parameter.nestedIfOptional();
        Class<?> type = parameter.getNestedParameterType();
        ReactiveAdapter adapter = this.getAdapterRegistry().getAdapter(type);
        if (adapter != null) {
            this.assertHasValues(adapter, parameter);
            parameter = parameter.nested();
            type = parameter.getNestedParameterType();
        }
        if (typePredicate.test(annotation, type)) {
            if (adapter == null) {
                return true;
            }
            throw this.buildReactiveWrapperException(parameter);
        }
        return false;
    }
}

