/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.metrics;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.reactivex.netty.channel.ChannelMetricEventProvider;
import io.reactivex.netty.metrics.Clock;
import io.reactivex.netty.metrics.MetricEventsSubject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class BytesInspector
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(BytesInspector.class);
    private final MetricEventsSubject eventsSubject;
    private final ChannelMetricEventProvider metricEventProvider;

    public BytesInspector(MetricEventsSubject eventsSubject, ChannelMetricEventProvider metricEventProvider) {
        this.eventsSubject = eventsSubject;
        this.metricEventProvider = metricEventProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (ByteBuf.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesRead((ByteBuf)msg);
            } else if (ByteBufHolder.class.isAssignableFrom(msg.getClass())) {
                ByteBufHolder holder = (ByteBufHolder)msg;
                this.publishBytesRead(holder.content());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to publish bytes read metrics event. This does *not* stop the pipeline processing.", e);
        }
        finally {
            super.channelRead(ctx, msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        try {
            if (ByteBuf.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesWritten(((ByteBuf)msg).readableBytes(), promise);
            } else if (ByteBufHolder.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesWritten(((ByteBufHolder)msg).content().readableBytes(), promise);
            } else if (FileRegion.class.isAssignableFrom(msg.getClass())) {
                this.publishBytesWritten(((FileRegion)msg).count(), promise);
            }
        }
        catch (Exception e) {
            logger.warn("Failed to publish bytes write metrics event. This does *not* stop the pipeline processing.", e);
        }
        finally {
            super.write(ctx, msg, promise);
        }
    }

    protected void publishBytesWritten(final long bytesToWrite, ChannelPromise promise) {
        if (bytesToWrite <= 0L) {
            return;
        }
        final long startTimeMillis = Clock.newStartTimeMillis();
        this.eventsSubject.onEvent(this.metricEventProvider.getWriteStartEvent(), (Object)bytesToWrite);
        promise.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    BytesInspector.this.eventsSubject.onEvent(BytesInspector.this.metricEventProvider.getWriteSuccessEvent(), Clock.onEndMillis(startTimeMillis), bytesToWrite);
                } else {
                    BytesInspector.this.eventsSubject.onEvent(BytesInspector.this.metricEventProvider.getWriteFailedEvent(), Clock.onEndMillis(startTimeMillis), future.cause(), (Object)bytesToWrite);
                }
            }
        });
    }

    protected void publishBytesRead(ByteBuf byteBuf) {
        if (null != byteBuf) {
            this.eventsSubject.onEvent(this.metricEventProvider.getBytesReadEvent(), (Object)byteBuf.readableBytes());
        }
    }
}

