/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.Cookie;
import io.netty.handler.codec.http.CookieEncoderUtil;
import io.netty.handler.codec.http.DefaultCookie;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

public final class ServerCookieDecoder {
    public static Set<Cookie> decode(String header) {
        if (header == null) {
            throw new NullPointerException("header");
        }
        int headerLen = header.length();
        if (headerLen == 0) {
            return Collections.emptySet();
        }
        TreeSet<Cookie> cookies = new TreeSet<Cookie>();
        int i2 = 0;
        boolean rfc2965Style = false;
        if (header.regionMatches(true, 0, "$Version", 0, 8)) {
            i2 = header.indexOf(59) + 1;
            rfc2965Style = true;
        }
        while (i2 != headerLen) {
            String value;
            int newNameEnd;
            int newNameStart;
            block18: {
                char c = header.charAt(i2);
                if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ',' || c == ';') {
                    ++i2;
                    continue;
                }
                newNameStart = i2;
                newNameEnd = i2;
                if (i2 == headerLen) {
                    value = null;
                } else {
                    do {
                        char curChar;
                        if ((curChar = header.charAt(i2)) == ';') {
                            newNameEnd = i2;
                            value = null;
                            break block18;
                        }
                        if (curChar != '=') continue;
                        newNameEnd = i2++;
                        if (i2 == headerLen) {
                            value = "";
                            break block18;
                        }
                        int newValueStart = i2;
                        char c2 = header.charAt(i2);
                        if (c2 == '\"') {
                            StringBuilder newValueBuf = CookieEncoderUtil.stringBuilder();
                            char q = c2;
                            boolean hadBackslash = false;
                            ++i2;
                            while (true) {
                                if (i2 == headerLen) {
                                    value = newValueBuf.toString();
                                    break block18;
                                }
                                if (hadBackslash) {
                                    hadBackslash = false;
                                    if ((c2 = header.charAt(i2++)) == '\\' || c2 == '\"') {
                                        newValueBuf.setCharAt(newValueBuf.length() - 1, c2);
                                        continue;
                                    }
                                    newValueBuf.append(c2);
                                    continue;
                                }
                                if ((c2 = header.charAt(i2++)) == q) {
                                    value = newValueBuf.toString();
                                    break block18;
                                }
                                newValueBuf.append(c2);
                                if (c2 != '\\') continue;
                                hadBackslash = true;
                            }
                        }
                        int semiPos = header.indexOf(59, i2);
                        if (semiPos > 0) {
                            value = header.substring(newValueStart, semiPos);
                            i2 = semiPos;
                        } else {
                            value = header.substring(newValueStart);
                            i2 = headerLen;
                        }
                        break block18;
                    } while (++i2 != headerLen);
                    newNameEnd = headerLen;
                    value = null;
                }
            }
            if (rfc2965Style && (header.regionMatches(newNameStart, "$Path", 0, "$Path".length()) || header.regionMatches(newNameStart, "$Domain", 0, "$Domain".length()) || header.regionMatches(newNameStart, "$Port", 0, "$Port".length()))) continue;
            String name = header.substring(newNameStart, newNameEnd);
            cookies.add(new DefaultCookie(name, value));
        }
        return cookies;
    }

    private ServerCookieDecoder() {
    }
}

