/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.Client;
import feign.Contract;
import feign.InvocationHandlerFactory;
import feign.Logger;
import feign.QueryMapEncoder;
import feign.Request;
import feign.RequestInterceptor;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public interface Capability {
    public static <E> E enrich(E componentToEnrich, List<Capability> capabilities) {
        return (E)capabilities.stream().reduce(componentToEnrich, (component, capability) -> Capability.invoke(component, capability), (component, enrichedComponent) -> enrichedComponent);
    }

    public static <E> E invoke(E target, Capability capability) {
        return (E)Arrays.stream(capability.getClass().getMethods()).filter(method2 -> method2.getName().equals("enrich")).filter(method2 -> method2.getReturnType().isInstance(target)).findFirst().map(method2 -> {
            try {
                return method2.invoke((Object)capability, target);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new RuntimeException("Unable to enrich " + target, e);
            }
        }).orElse(target);
    }

    default public Client enrich(Client client) {
        return client;
    }

    default public Retryer enrich(Retryer retryer) {
        return retryer;
    }

    default public RequestInterceptor enrich(RequestInterceptor requestInterceptor) {
        return requestInterceptor;
    }

    default public Logger enrich(Logger logger) {
        return logger;
    }

    default public Logger.Level enrich(Logger.Level level) {
        return level;
    }

    default public Contract enrich(Contract contract) {
        return contract;
    }

    default public Request.Options enrich(Request.Options options) {
        return options;
    }

    default public Encoder enrich(Encoder encoder) {
        return encoder;
    }

    default public Decoder enrich(Decoder decoder) {
        return decoder;
    }

    default public InvocationHandlerFactory enrich(InvocationHandlerFactory invocationHandlerFactory) {
        return invocationHandlerFactory;
    }

    default public QueryMapEncoder enrich(QueryMapEncoder queryMapEncoder) {
        return queryMapEncoder;
    }
}

