/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.jetty9;

import com.github.tomakehurst.wiremock.common.Exceptions;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.servlet.WireMockHttpServletMultipartAdapter;
import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import java.io.ByteArrayInputStream;
import java.util.Collection;
import javax.servlet.http.Part;
import org.eclipse.jetty.util.MultiPartInputStreamParser;

public class MultipartParser {
    public static Collection<Request.Part> parse(byte[] body2, String contentType2) {
        MultiPartInputStreamParser parser = new MultiPartInputStreamParser(new ByteArrayInputStream(body2), contentType2, null, null);
        try {
            return FluentIterable.from(parser.getParts()).transform(new Function<Part, Request.Part>(){

                @Override
                public Request.Part apply(Part input) {
                    return WireMockHttpServletMultipartAdapter.from(input);
                }
            }).toList();
        }
        catch (Exception e) {
            return Exceptions.throwUnchecked(e, Collection.class);
        }
    }
}

