/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.FluxMetrics;
import reactor.core.publisher.InnerOperator;
import reactor.core.publisher.InternalMonoOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.util.annotation.Nullable;

final class MonoMetrics<T>
extends InternalMonoOperator<T, T> {
    final String name;
    final Tags tags;
    final MeterRegistry meterRegistry;

    MonoMetrics(Mono<? extends T> mono2) {
        this(mono2, null);
    }

    MonoMetrics(Mono<? extends T> mono2, @Nullable MeterRegistry meterRegistry) {
        super(mono2);
        this.name = FluxMetrics.resolveName(mono2);
        this.tags = FluxMetrics.resolveTags(mono2, FluxMetrics.DEFAULT_TAGS_MONO, this.name);
        this.meterRegistry = meterRegistry == null ? Metrics.globalRegistry : meterRegistry;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new MetricsSubscriber<T>(actual, this.meterRegistry, Clock.SYSTEM, this.tags);
    }

    static class MetricsSubscriber<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final Clock clock;
        final Tags commonTags;
        final MeterRegistry registry;
        Timer.Sample subscribeToTerminateSample;
        boolean done;
        Subscription s;

        MetricsSubscriber(CoreSubscriber<? super T> actual, MeterRegistry registry, Clock clock, Tags commonTags) {
            this.actual = actual;
            this.clock = clock;
            this.commonTags = commonTags;
            this.registry = registry;
        }

        @Override
        public final CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        @Override
        public final void cancel() {
            FluxMetrics.recordCancel(this.commonTags, this.registry, this.subscribeToTerminateSample);
            this.s.cancel();
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            FluxMetrics.recordOnComplete(this.commonTags, this.registry, this.subscribeToTerminateSample);
            this.actual.onComplete();
        }

        @Override
        public final void onError(Throwable e) {
            if (this.done) {
                FluxMetrics.recordMalformed(this.commonTags, this.registry);
                Operators.onErrorDropped(e, this.actual.currentContext());
                return;
            }
            this.done = true;
            FluxMetrics.recordOnError(this.commonTags, this.registry, this.subscribeToTerminateSample, e);
            this.actual.onError(e);
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                FluxMetrics.recordMalformed(this.commonTags, this.registry);
                Operators.onNextDropped(t, this.actual.currentContext());
                return;
            }
            this.done = true;
            FluxMetrics.recordOnComplete(this.commonTags, this.registry, this.subscribeToTerminateSample);
            this.actual.onNext(t);
            this.actual.onComplete();
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (Operators.validate(this.s, s2)) {
                FluxMetrics.recordOnSubscribe(this.commonTags, this.registry);
                this.subscribeToTerminateSample = Timer.start((Clock)this.clock);
                this.s = s2;
                this.actual.onSubscribe(this);
            }
        }

        @Override
        public final void request(long l) {
            if (Operators.validate(l)) {
                this.s.request(l);
            }
        }
    }
}

