/*
 * Decompiled with CFR 0.152.
 */
package feign.template;

import feign.Util;
import feign.template.Template;
import feign.template.TemplateChunk;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public final class HeaderTemplate
extends Template {
    private LinkedHashSet<String> values;
    private String name;

    public static HeaderTemplate from(String name, List<TemplateChunk> chunks) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is required.");
        }
        if (chunks == null) {
            throw new IllegalArgumentException("chunks are required.");
        }
        return new HeaderTemplate(name, Util.UTF_8, chunks);
    }

    public static HeaderTemplate create(String name, Iterable<String> values) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name is required.");
        }
        if (values == null) {
            throw new IllegalArgumentException("values are required");
        }
        StringBuilder template = new StringBuilder();
        template.append(name).append(" ");
        Iterator<String> iterator = values.iterator();
        while (iterator.hasNext()) {
            template.append(iterator.next());
            if (!iterator.hasNext()) continue;
            template.append(",");
        }
        return new HeaderTemplate(template.toString(), name, values, Util.UTF_8);
    }

    public static HeaderTemplate append(HeaderTemplate headerTemplate, Iterable<String> values) {
        LinkedHashSet<String> headerValues = new LinkedHashSet<String>(headerTemplate.getValues());
        headerValues.addAll(StreamSupport.stream(values.spliterator(), false).filter(Util::isNotBlank).collect(Collectors.toCollection(LinkedHashSet::new)));
        return HeaderTemplate.create(headerTemplate.getName(), headerValues);
    }

    public static HeaderTemplate appendFrom(HeaderTemplate headerTemplate, List<TemplateChunk> chunks) {
        CopyOnWriteArrayList<TemplateChunk> existing = new CopyOnWriteArrayList<TemplateChunk>(headerTemplate.getTemplateChunks());
        existing.addAll(chunks);
        return HeaderTemplate.from(headerTemplate.getName(), existing);
    }

    private HeaderTemplate(String template, String name, Iterable<String> values, Charset charset) {
        super(template, Template.ExpansionOptions.REQUIRED, Template.EncodingOptions.NOT_REQUIRED, false, charset);
        this.values = StreamSupport.stream(values.spliterator(), false).filter(Util::isNotBlank).collect(Collectors.toCollection(LinkedHashSet::new));
        this.name = name;
    }

    private HeaderTemplate(String name, Charset charset, List<TemplateChunk> chunks) {
        super(Template.ExpansionOptions.REQUIRED, Template.EncodingOptions.NOT_REQUIRED, false, charset, chunks);
        this.values = chunks.stream().map(TemplateChunk::getValue).collect(Collectors.toCollection(LinkedHashSet::new));
        this.name = name;
    }

    public Collection<String> getValues() {
        return Collections.unmodifiableCollection(this.values);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String expand(Map<String, ?> variables) {
        String result = super.expand(variables);
        while (result.endsWith(",")) {
            result = result.replaceAll(",$", "");
        }
        result = result.replaceAll(",", ", ");
        return result;
    }
}

