/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.recording;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.common.ContentTypes;
import com.github.tomakehurst.wiremock.common.FileSource;
import com.github.tomakehurst.wiremock.common.SafeNames;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;

public class SnapshotStubMappingBodyExtractor {
    private final FileSource fileSource;

    public SnapshotStubMappingBodyExtractor(FileSource fileSource) {
        this.fileSource = fileSource;
    }

    public void extractInPlace(StubMapping stubMapping) {
        byte[] body2 = stubMapping.getResponse().getByteBody();
        HttpHeaders responseHeaders = stubMapping.getResponse().getHeaders();
        String extension = ContentTypes.determineFileExtension(stubMapping.getRequest().getUrl(), responseHeaders != null ? responseHeaders.getContentTypeHeader() : ContentTypeHeader.absent(), body2);
        String bodyFileName = SafeNames.makeSafeFileName(stubMapping, extension);
        String noStringBody = null;
        byte[] noByteBody = null;
        stubMapping.setResponse(ResponseDefinitionBuilder.like(stubMapping.getResponse()).withBodyFile(bodyFileName).withBody(noStringBody).withBody(noByteBody).withBase64Body(null).build());
        this.fileSource.writeBinaryFile(bodyFileName, body2);
    }
}

