/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.util;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xmlunit.util.IterableNodeList;

public final class Nodes {
    private static final char SPACE = ' ';

    private Nodes() {
    }

    public static QName getQName(Node n) {
        String s2 = n.getLocalName();
        String p = n.getPrefix();
        return s2 != null ? new QName(n.getNamespaceURI(), s2, p != null ? p : "") : new QName(n.getNodeName());
    }

    public static String getMergedNestedText(Node n) {
        StringBuilder sb = new StringBuilder();
        for (Node child : new IterableNodeList(n.getChildNodes())) {
            String s2;
            if (!(child instanceof Text) || (s2 = child.getNodeValue()) == null) continue;
            sb.append(s2);
        }
        return sb.toString();
    }

    public static Map<QName, String> getAttributes(Node n) {
        LinkedHashMap<QName, String> map = new LinkedHashMap<QName, String>();
        NamedNodeMap m3 = n.getAttributes();
        if (m3 != null) {
            int len = m3.getLength();
            for (int i2 = 0; i2 < len; ++i2) {
                Attr a = (Attr)m3.item(i2);
                map.put(Nodes.getQName(a), a.getValue());
            }
        }
        return map;
    }

    public static Node stripWhitespace(Node original) {
        Node cloned = original.cloneNode(true);
        cloned.normalize();
        Nodes.handleWsRec(cloned, false);
        return cloned;
    }

    public static Node normalizeWhitespace(Node original) {
        Node cloned = original.cloneNode(true);
        cloned.normalize();
        Nodes.handleWsRec(cloned, true);
        return cloned;
    }

    public static Node stripElementContentWhitespace(Node original) {
        Node cloned = original.cloneNode(true);
        cloned.normalize();
        Nodes.stripECW(cloned);
        return cloned;
    }

    private static void handleWsRec(Node n, boolean normalize) {
        if (n instanceof CharacterData || n instanceof ProcessingInstruction) {
            String s2 = n.getNodeValue().trim();
            if (normalize) {
                s2 = Nodes.normalize(s2);
            }
            n.setNodeValue(s2);
        }
        LinkedList<Node> toRemove = new LinkedList<Node>();
        for (Node child : new IterableNodeList(n.getChildNodes())) {
            Nodes.handleWsRec(child, normalize);
            if (n instanceof Attr || !(child instanceof Text) || child.getNodeValue().length() != 0) continue;
            toRemove.add(child);
        }
        for (Node child : toRemove) {
            n.removeChild(child);
        }
        NamedNodeMap attrs = n.getAttributes();
        if (attrs != null) {
            int len = attrs.getLength();
            for (int i2 = 0; i2 < len; ++i2) {
                Nodes.handleWsRec(attrs.item(i2), normalize);
            }
        }
    }

    static String normalize(String s2) {
        StringBuilder sb = new StringBuilder();
        boolean changed = false;
        boolean lastCharWasWS = false;
        int len = s2.length();
        for (int i2 = 0; i2 < len; ++i2) {
            char c = s2.charAt(i2);
            if (Character.isWhitespace(c)) {
                if (!lastCharWasWS) {
                    sb.append(' ');
                    changed |= c != ' ';
                } else {
                    changed = true;
                }
                lastCharWasWS = true;
                continue;
            }
            sb.append(c);
            lastCharWasWS = false;
        }
        return changed ? sb.toString() : s2;
    }

    private static void stripECW(Node n) {
        LinkedList<Node> toRemove = new LinkedList<Node>();
        for (Node child : new IterableNodeList(n.getChildNodes())) {
            Nodes.stripECW(child);
            if (n instanceof Attr || !(child instanceof Text) || child.getNodeValue().trim().length() != 0) continue;
            toRemove.add(child);
        }
        for (Node child : toRemove) {
            n.removeChild(child);
        }
    }
}

