/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.result.method;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;
import org.springframework.web.reactive.result.condition.ConsumesRequestCondition;
import org.springframework.web.reactive.result.condition.HeadersRequestCondition;
import org.springframework.web.reactive.result.condition.ParamsRequestCondition;
import org.springframework.web.reactive.result.condition.PatternsRequestCondition;
import org.springframework.web.reactive.result.condition.ProducesRequestCondition;
import org.springframework.web.reactive.result.condition.RequestCondition;
import org.springframework.web.reactive.result.condition.RequestConditionHolder;
import org.springframework.web.reactive.result.condition.RequestMethodsRequestCondition;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public final class RequestMappingInfo
implements RequestCondition<RequestMappingInfo> {
    private static final PatternsRequestCondition EMPTY_PATTERNS = new PatternsRequestCondition(new PathPattern[0]);
    private static final RequestMethodsRequestCondition EMPTY_REQUEST_METHODS = new RequestMethodsRequestCondition(new RequestMethod[0]);
    private static final ParamsRequestCondition EMPTY_PARAMS = new ParamsRequestCondition(new String[0]);
    private static final HeadersRequestCondition EMPTY_HEADERS = new HeadersRequestCondition(new String[0]);
    private static final ConsumesRequestCondition EMPTY_CONSUMES = new ConsumesRequestCondition(new String[0]);
    private static final ProducesRequestCondition EMPTY_PRODUCES = new ProducesRequestCondition(new String[0]);
    private static final RequestConditionHolder EMPTY_CUSTOM = new RequestConditionHolder(null);
    @Nullable
    private final String name;
    private final PatternsRequestCondition patternsCondition;
    private final RequestMethodsRequestCondition methodsCondition;
    private final ParamsRequestCondition paramsCondition;
    private final HeadersRequestCondition headersCondition;
    private final ConsumesRequestCondition consumesCondition;
    private final ProducesRequestCondition producesCondition;
    private final RequestConditionHolder customConditionHolder;
    private final int hashCode;

    public RequestMappingInfo(@Nullable String name, @Nullable PatternsRequestCondition patterns, @Nullable RequestMethodsRequestCondition methods, @Nullable ParamsRequestCondition params, @Nullable HeadersRequestCondition headers2, @Nullable ConsumesRequestCondition consumes, @Nullable ProducesRequestCondition produces, @Nullable RequestCondition<?> custom) {
        this.name = StringUtils.hasText(name) ? name : null;
        this.patternsCondition = patterns != null ? patterns : EMPTY_PATTERNS;
        this.methodsCondition = methods != null ? methods : EMPTY_REQUEST_METHODS;
        this.paramsCondition = params != null ? params : EMPTY_PARAMS;
        this.headersCondition = headers2 != null ? headers2 : EMPTY_HEADERS;
        this.consumesCondition = consumes != null ? consumes : EMPTY_CONSUMES;
        this.producesCondition = produces != null ? produces : EMPTY_PRODUCES;
        this.customConditionHolder = custom != null ? new RequestConditionHolder(custom) : EMPTY_CUSTOM;
        this.hashCode = RequestMappingInfo.calculateHashCode(this.patternsCondition, this.methodsCondition, this.paramsCondition, this.headersCondition, this.consumesCondition, this.producesCondition, this.customConditionHolder);
    }

    public RequestMappingInfo(@Nullable PatternsRequestCondition patterns, @Nullable RequestMethodsRequestCondition methods, @Nullable ParamsRequestCondition params, @Nullable HeadersRequestCondition headers2, @Nullable ConsumesRequestCondition consumes, @Nullable ProducesRequestCondition produces, @Nullable RequestCondition<?> custom) {
        this(null, patterns, methods, params, headers2, consumes, produces, custom);
    }

    public RequestMappingInfo(RequestMappingInfo info, @Nullable RequestCondition<?> customRequestCondition) {
        this(info.name, info.patternsCondition, info.methodsCondition, info.paramsCondition, info.headersCondition, info.consumesCondition, info.producesCondition, customRequestCondition);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public PatternsRequestCondition getPatternsCondition() {
        return this.patternsCondition;
    }

    public RequestMethodsRequestCondition getMethodsCondition() {
        return this.methodsCondition;
    }

    public ParamsRequestCondition getParamsCondition() {
        return this.paramsCondition;
    }

    public HeadersRequestCondition getHeadersCondition() {
        return this.headersCondition;
    }

    public ConsumesRequestCondition getConsumesCondition() {
        return this.consumesCondition;
    }

    public ProducesRequestCondition getProducesCondition() {
        return this.producesCondition;
    }

    @Nullable
    public RequestCondition<?> getCustomCondition() {
        return this.customConditionHolder.getCondition();
    }

    @Override
    public RequestMappingInfo combine(RequestMappingInfo other) {
        String name = this.combineNames(other);
        PatternsRequestCondition patterns = this.patternsCondition.combine(other.patternsCondition);
        RequestMethodsRequestCondition methods = this.methodsCondition.combine(other.methodsCondition);
        ParamsRequestCondition params = this.paramsCondition.combine(other.paramsCondition);
        HeadersRequestCondition headers2 = this.headersCondition.combine(other.headersCondition);
        ConsumesRequestCondition consumes = this.consumesCondition.combine(other.consumesCondition);
        ProducesRequestCondition produces = this.producesCondition.combine(other.producesCondition);
        RequestConditionHolder custom = this.customConditionHolder.combine(other.customConditionHolder);
        return new RequestMappingInfo(name, patterns, methods, params, headers2, consumes, produces, custom.getCondition());
    }

    @Nullable
    private String combineNames(RequestMappingInfo other) {
        if (this.name != null && other.name != null) {
            return this.name + "#" + other.name;
        }
        if (this.name != null) {
            return this.name;
        }
        return other.name;
    }

    @Override
    @Nullable
    public RequestMappingInfo getMatchingCondition(ServerWebExchange exchange2) {
        RequestMethodsRequestCondition methods = this.methodsCondition.getMatchingCondition(exchange2);
        if (methods == null) {
            return null;
        }
        ParamsRequestCondition params = this.paramsCondition.getMatchingCondition(exchange2);
        if (params == null) {
            return null;
        }
        HeadersRequestCondition headers2 = this.headersCondition.getMatchingCondition(exchange2);
        if (headers2 == null) {
            return null;
        }
        ConsumesRequestCondition consumes = this.consumesCondition.getMatchingCondition(exchange2);
        if (consumes == null) {
            return null;
        }
        ProducesRequestCondition produces = this.producesCondition.getMatchingCondition(exchange2);
        if (produces == null) {
            return null;
        }
        PatternsRequestCondition patterns = this.patternsCondition.getMatchingCondition(exchange2);
        if (patterns == null) {
            return null;
        }
        RequestConditionHolder custom = this.customConditionHolder.getMatchingCondition(exchange2);
        if (custom == null) {
            return null;
        }
        return new RequestMappingInfo(this.name, patterns, methods, params, headers2, consumes, produces, custom.getCondition());
    }

    @Override
    public int compareTo(RequestMappingInfo other, ServerWebExchange exchange2) {
        int result = this.patternsCondition.compareTo(other.getPatternsCondition(), exchange2);
        if (result != 0) {
            return result;
        }
        result = this.paramsCondition.compareTo(other.getParamsCondition(), exchange2);
        if (result != 0) {
            return result;
        }
        result = this.headersCondition.compareTo(other.getHeadersCondition(), exchange2);
        if (result != 0) {
            return result;
        }
        result = this.consumesCondition.compareTo(other.getConsumesCondition(), exchange2);
        if (result != 0) {
            return result;
        }
        result = this.producesCondition.compareTo(other.getProducesCondition(), exchange2);
        if (result != 0) {
            return result;
        }
        result = this.methodsCondition.compareTo(other.getMethodsCondition(), exchange2);
        if (result != 0) {
            return result;
        }
        result = this.customConditionHolder.compareTo(other.customConditionHolder, exchange2);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestMappingInfo)) {
            return false;
        }
        RequestMappingInfo otherInfo = (RequestMappingInfo)other;
        return this.patternsCondition.equals(otherInfo.patternsCondition) && this.methodsCondition.equals(otherInfo.methodsCondition) && this.paramsCondition.equals(otherInfo.paramsCondition) && this.headersCondition.equals(otherInfo.headersCondition) && this.consumesCondition.equals(otherInfo.consumesCondition) && this.producesCondition.equals(otherInfo.producesCondition) && this.customConditionHolder.equals(otherInfo.customConditionHolder);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private static int calculateHashCode(PatternsRequestCondition patterns, RequestMethodsRequestCondition methods, ParamsRequestCondition params, HeadersRequestCondition headers2, ConsumesRequestCondition consumes, ProducesRequestCondition produces, RequestConditionHolder custom) {
        return patterns.hashCode() * 31 + methods.hashCode() + params.hashCode() + headers2.hashCode() + consumes.hashCode() + produces.hashCode() + custom.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (!this.methodsCondition.isEmpty()) {
            Set<RequestMethod> httpMethods = this.methodsCondition.getMethods();
            builder.append(httpMethods.size() == 1 ? httpMethods.iterator().next() : httpMethods);
        }
        if (!this.patternsCondition.isEmpty()) {
            Set<PathPattern> patterns = this.patternsCondition.getPatterns();
            builder.append(" ").append(patterns.size() == 1 ? patterns.iterator().next() : patterns);
        }
        if (!this.paramsCondition.isEmpty()) {
            builder.append(", params ").append(this.paramsCondition);
        }
        if (!this.headersCondition.isEmpty()) {
            builder.append(", headers ").append(this.headersCondition);
        }
        if (!this.consumesCondition.isEmpty()) {
            builder.append(", consumes ").append(this.consumesCondition);
        }
        if (!this.producesCondition.isEmpty()) {
            builder.append(", produces ").append(this.producesCondition);
        }
        if (!this.customConditionHolder.isEmpty()) {
            builder.append(", and ").append(this.customConditionHolder);
        }
        builder.append('}');
        return builder.toString();
    }

    public static Builder paths(String ... paths) {
        return new DefaultBuilder(paths);
    }

    public static class BuilderConfiguration {
        @Nullable
        private PathPatternParser patternParser;
        @Nullable
        private RequestedContentTypeResolver contentTypeResolver;

        public void setPatternParser(PathPatternParser patternParser) {
            this.patternParser = patternParser;
        }

        @Nullable
        public PathPatternParser getPatternParser() {
            return this.patternParser;
        }

        public void setContentTypeResolver(RequestedContentTypeResolver resolver) {
            this.contentTypeResolver = resolver;
        }

        @Nullable
        public RequestedContentTypeResolver getContentTypeResolver() {
            return this.contentTypeResolver;
        }
    }

    private static class DefaultBuilder
    implements Builder {
        private String[] paths;
        @Nullable
        private RequestMethod[] methods;
        @Nullable
        private String[] params;
        @Nullable
        private String[] headers;
        @Nullable
        private String[] consumes;
        @Nullable
        private String[] produces;
        private boolean hasContentType;
        private boolean hasAccept;
        @Nullable
        private String mappingName;
        @Nullable
        private RequestCondition<?> customCondition;
        private BuilderConfiguration options = new BuilderConfiguration();

        public DefaultBuilder(String ... paths) {
            this.paths = paths;
        }

        @Override
        public Builder paths(String ... paths) {
            this.paths = paths;
            return this;
        }

        @Override
        public DefaultBuilder methods(RequestMethod ... methods) {
            this.methods = methods;
            return this;
        }

        @Override
        public DefaultBuilder params(String ... params) {
            this.params = params;
            return this;
        }

        @Override
        public DefaultBuilder headers(String ... headers2) {
            for (String header : headers2) {
                this.hasContentType = this.hasContentType || header.contains("Content-Type") || header.contains("content-type");
                this.hasAccept = this.hasAccept || header.contains("Accept") || header.contains("accept");
            }
            this.headers = headers2;
            return this;
        }

        @Override
        public DefaultBuilder consumes(String ... consumes) {
            this.consumes = consumes;
            return this;
        }

        @Override
        public DefaultBuilder produces(String ... produces) {
            this.produces = produces;
            return this;
        }

        @Override
        public DefaultBuilder mappingName(String name) {
            this.mappingName = name;
            return this;
        }

        @Override
        public DefaultBuilder customCondition(RequestCondition<?> condition) {
            this.customCondition = condition;
            return this;
        }

        @Override
        public Builder options(BuilderConfiguration options) {
            this.options = options;
            return this;
        }

        @Override
        public RequestMappingInfo build() {
            PathPatternParser parser = this.options.getPatternParser() != null ? this.options.getPatternParser() : PathPatternParser.defaultInstance;
            RequestedContentTypeResolver contentTypeResolver = this.options.getContentTypeResolver();
            return new RequestMappingInfo(this.mappingName, DefaultBuilder.isEmpty(this.paths) ? null : new PatternsRequestCondition(DefaultBuilder.parse(this.paths, parser)), ObjectUtils.isEmpty((Object[])this.methods) ? null : new RequestMethodsRequestCondition(this.methods), ObjectUtils.isEmpty(this.params) ? null : new ParamsRequestCondition(this.params), ObjectUtils.isEmpty(this.headers) ? null : new HeadersRequestCondition(this.headers), (ConsumesRequestCondition)(ObjectUtils.isEmpty(this.consumes) && !this.hasContentType ? null : new ConsumesRequestCondition(this.consumes, this.headers)), (ProducesRequestCondition)(ObjectUtils.isEmpty(this.produces) && !this.hasAccept ? null : new ProducesRequestCondition(this.produces, this.headers, contentTypeResolver)), this.customCondition);
        }

        private static List<PathPattern> parse(String[] patterns, PathPatternParser parser) {
            if (DefaultBuilder.isEmpty(patterns)) {
                return Collections.emptyList();
            }
            ArrayList<PathPattern> result = new ArrayList<PathPattern>(patterns.length);
            for (String path2 : patterns) {
                if (StringUtils.hasText(path2) && !path2.startsWith("/")) {
                    path2 = "/" + path2;
                }
                result.add(parser.parse(path2));
            }
            return result;
        }

        private static boolean isEmpty(String[] patterns) {
            if (!ObjectUtils.isEmpty(patterns)) {
                for (String pattern : patterns) {
                    if (!StringUtils.hasText(pattern)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    public static interface Builder {
        public Builder paths(String ... var1);

        public Builder methods(RequestMethod ... var1);

        public Builder params(String ... var1);

        public Builder headers(String ... var1);

        public Builder consumes(String ... var1);

        public Builder produces(String ... var1);

        public Builder mappingName(String var1);

        public Builder customCondition(RequestCondition<?> var1);

        public Builder options(BuilderConfiguration var1);

        public RequestMappingInfo build();
    }
}

