/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.utils;

public final class HttpUtils {
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    public static final String TEXT = "text/plain";
    public static final String TEXT_UTF_8 = "text/plain;charset=utf-8";
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_JSON_UTF_8 = "application/json;charset=utf-8";
    public static final String APPLICATION_STREAM_JSON = "application/stream+json";
    public static final String APPLICATION_STREAM_JSON_UTF_8 = "application/stream+json;charset=utf-8";
    public static final byte[] NEWLINE_SEPARATOR = new byte[]{10};
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    public static final String ACCEPT_HEADER = "Accept";
    public static final String ACCEPT_ENCODING_HEADER = "Accept-Encoding";
    public static final String GZIP = "gzip";

    private HttpUtils() {
    }

    public static StatusCodeFamily familyOf(int statusCode) {
        switch (statusCode / 100) {
            case 1: {
                return StatusCodeFamily.INFORMATIONAL;
            }
            case 2: {
                return StatusCodeFamily.SUCCESSFUL;
            }
            case 3: {
                return StatusCodeFamily.REDIRECTION;
            }
            case 4: {
                return StatusCodeFamily.CLIENT_ERROR;
            }
            case 5: {
                return StatusCodeFamily.SERVER_ERROR;
            }
        }
        return StatusCodeFamily.OTHER;
    }

    public static enum StatusCodeFamily {
        INFORMATIONAL(true),
        SUCCESSFUL(false),
        REDIRECTION(true),
        CLIENT_ERROR(true),
        SERVER_ERROR(true),
        OTHER(false);

        private final boolean error;

        private StatusCodeFamily(boolean error) {
            this.error = error;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

