/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import org.reactivestreams.Publisher;
import reactivefeign.client.DelegatingReactiveHttpResponse;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.ReactiveHttpResponseMapper;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.client.statushandler.ReactiveStatusHandlers;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StatusHandlerPostProcessor<P extends Publisher<?>>
implements ReactiveHttpResponseMapper<P> {
    private final ReactiveStatusHandler statusHandler;
    private static final ReactiveStatusHandler defaultStatusHandler = ReactiveStatusHandlers.defaultFeignErrorDecoder();

    public static StatusHandlerPostProcessor handleStatus(ReactiveStatusHandler statusHandler) {
        return new StatusHandlerPostProcessor(statusHandler);
    }

    private StatusHandlerPostProcessor(ReactiveStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    @Override
    public Mono<ReactiveHttpResponse<P>> apply(ReactiveHttpResponse<P> response) {
        String methodTag = response.request().methodKey();
        ReactiveHttpResponse<P> errorResponse = response;
        if (this.statusHandler.shouldHandle(response.status())) {
            errorResponse = new ErrorReactiveHttpResponse<P>(response, this.statusHandler.decode(methodTag, response));
        } else if (defaultStatusHandler.shouldHandle(response.status())) {
            errorResponse = new ErrorReactiveHttpResponse<P>(response, defaultStatusHandler.decode(methodTag, response));
        }
        return Mono.just(errorResponse);
    }

    private static class ErrorReactiveHttpResponse<P extends Publisher<?>>
    extends DelegatingReactiveHttpResponse<P> {
        private final Mono<? extends Throwable> error;

        ErrorReactiveHttpResponse(ReactiveHttpResponse<P> response, Mono<? extends Throwable> error) {
            super(response);
            this.error = error;
        }

        @Override
        public P body() {
            if (this.getResponse().body() instanceof Mono) {
                return (P)this.error.flatMap(Mono::error);
            }
            return (P)this.error.flatMapMany(Flux::error);
        }
    }
}

