/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractListenerWebSocketSession;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoProcessor;

public class UndertowWebSocketSession
extends AbstractListenerWebSocketSession<WebSocketChannel> {
    public UndertowWebSocketSession(WebSocketChannel channel, HandshakeInfo info, DataBufferFactory factory) {
        this(channel, info, factory, null);
    }

    public UndertowWebSocketSession(WebSocketChannel channel, HandshakeInfo info, DataBufferFactory factory, @Nullable MonoProcessor<Void> completionMono) {
        super(channel, ObjectUtils.getIdentityHexString(channel), info, factory, completionMono);
        this.suspendReceiving();
    }

    @Override
    protected boolean canSuspendReceiving() {
        return true;
    }

    @Override
    protected void suspendReceiving() {
        ((WebSocketChannel)this.getDelegate()).suspendReceives();
    }

    @Override
    protected void resumeReceiving() {
        ((WebSocketChannel)this.getDelegate()).resumeReceives();
    }

    @Override
    protected boolean sendMessage(WebSocketMessage message) throws IOException {
        ByteBuffer buffer = message.getPayload().asByteBuffer();
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            String text = new String(buffer.array(), StandardCharsets.UTF_8);
            WebSockets.sendText((String)text, (WebSocketChannel)((WebSocketChannel)this.getDelegate()), (WebSocketCallback)new SendProcessorCallback(message.getPayload()));
        } else if (WebSocketMessage.Type.BINARY.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            WebSockets.sendBinary((ByteBuffer)buffer, (WebSocketChannel)((WebSocketChannel)this.getDelegate()), (WebSocketCallback)new SendProcessorCallback(message.getPayload()));
        } else if (WebSocketMessage.Type.PING.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            WebSockets.sendPing((ByteBuffer)buffer, (WebSocketChannel)((WebSocketChannel)this.getDelegate()), (WebSocketCallback)new SendProcessorCallback(message.getPayload()));
        } else if (WebSocketMessage.Type.PONG.equals((Object)message.getType())) {
            this.getSendProcessor().setReadyToSend(false);
            WebSockets.sendPong((ByteBuffer)buffer, (WebSocketChannel)((WebSocketChannel)this.getDelegate()), (WebSocketCallback)new SendProcessorCallback(message.getPayload()));
        } else {
            throw new IllegalArgumentException("Unexpected message type: " + (Object)((Object)message.getType()));
        }
        return true;
    }

    @Override
    public Mono<Void> close(CloseStatus status) {
        CloseMessage cm = new CloseMessage(status.getCode(), status.getReason());
        if (!((WebSocketChannel)this.getDelegate()).isCloseFrameSent()) {
            WebSockets.sendClose((CloseMessage)cm, (WebSocketChannel)((WebSocketChannel)this.getDelegate()), null);
        }
        return Mono.empty();
    }

    private final class SendProcessorCallback
    implements WebSocketCallback<Void> {
        private final DataBuffer payload;

        SendProcessorCallback(DataBuffer payload) {
            this.payload = payload;
        }

        public void complete(WebSocketChannel channel, Void context) {
            DataBufferUtils.release(this.payload);
            UndertowWebSocketSession.this.getSendProcessor().setReadyToSend(true);
            UndertowWebSocketSession.this.getSendProcessor().onWritePossible();
        }

        public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
            DataBufferUtils.release(this.payload);
            UndertowWebSocketSession.this.getSendProcessor().cancel();
            UndertowWebSocketSession.this.getSendProcessor().onError(throwable);
        }
    }
}

