/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.adapter;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.buffer.NettyDataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.adapter.AbstractWebSocketSession;

public abstract class NettyWebSocketSessionSupport<T>
extends AbstractWebSocketSession<T> {
    public static final int DEFAULT_FRAME_MAX_SIZE = 65536;
    private static final Map<Class<?>, WebSocketMessage.Type> messageTypes = new HashMap(8);

    protected NettyWebSocketSessionSupport(T delegate, HandshakeInfo info, NettyDataBufferFactory factory) {
        super(delegate, ObjectUtils.getIdentityHexString(delegate), info, factory);
    }

    @Override
    public NettyDataBufferFactory bufferFactory() {
        return (NettyDataBufferFactory)super.bufferFactory();
    }

    protected WebSocketMessage toMessage(WebSocketFrame frame) {
        NettyDataBuffer payload = this.bufferFactory().wrap(frame.content());
        return new WebSocketMessage(messageTypes.get(frame.getClass()), payload);
    }

    protected WebSocketFrame toFrame(WebSocketMessage message) {
        ByteBuf byteBuf = NettyDataBufferFactory.toByteBuf(message.getPayload());
        if (WebSocketMessage.Type.TEXT.equals((Object)message.getType())) {
            return new TextWebSocketFrame(byteBuf);
        }
        if (WebSocketMessage.Type.BINARY.equals((Object)message.getType())) {
            return new BinaryWebSocketFrame(byteBuf);
        }
        if (WebSocketMessage.Type.PING.equals((Object)message.getType())) {
            return new PingWebSocketFrame(byteBuf);
        }
        if (WebSocketMessage.Type.PONG.equals((Object)message.getType())) {
            return new PongWebSocketFrame(byteBuf);
        }
        throw new IllegalArgumentException("Unexpected message type: " + (Object)((Object)message.getType()));
    }

    static {
        messageTypes.put(TextWebSocketFrame.class, WebSocketMessage.Type.TEXT);
        messageTypes.put(BinaryWebSocketFrame.class, WebSocketMessage.Type.BINARY);
        messageTypes.put(PingWebSocketFrame.class, WebSocketMessage.Type.PING);
        messageTypes.put(PongWebSocketFrame.class, WebSocketMessage.Type.PONG);
    }
}

