/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.ode.nonstiff;

import org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import org.apache.commons.math3.ode.sampling.StepInterpolator;
import org.apache.commons.math3.util.FastMath;

class GillStepInterpolator
extends RungeKuttaStepInterpolator {
    private static final double ONE_MINUS_INV_SQRT_2 = 1.0 - FastMath.sqrt(0.5);
    private static final double ONE_PLUS_INV_SQRT_2 = 1.0 + FastMath.sqrt(0.5);
    private static final long serialVersionUID = 20111120L;

    public GillStepInterpolator() {
    }

    public GillStepInterpolator(GillStepInterpolator interpolator) {
        super(interpolator);
    }

    protected StepInterpolator doCopy() {
        return new GillStepInterpolator(this);
    }

    protected void computeInterpolatedStateAndDerivatives(double theta, double oneMinusThetaH) {
        double twoTheta = 2.0 * theta;
        double fourTheta2 = twoTheta * twoTheta;
        double coeffDot1 = theta * (twoTheta - 3.0) + 1.0;
        double cDot23 = twoTheta * (1.0 - theta);
        double coeffDot2 = cDot23 * ONE_MINUS_INV_SQRT_2;
        double coeffDot3 = cDot23 * ONE_PLUS_INV_SQRT_2;
        double coeffDot4 = theta * (twoTheta - 1.0);
        if (this.previousState != null && theta <= 0.5) {
            double s2 = theta * this.h / 6.0;
            double c23 = s2 * (6.0 * theta - fourTheta2);
            double coeff1 = s2 * (6.0 - 9.0 * theta + fourTheta2);
            double coeff2 = c23 * ONE_MINUS_INV_SQRT_2;
            double coeff3 = c23 * ONE_PLUS_INV_SQRT_2;
            double coeff4 = s2 * (-3.0 * theta + fourTheta2);
            for (int i2 = 0; i2 < this.interpolatedState.length; ++i2) {
                double yDot1 = this.yDotK[0][i2];
                double yDot2 = this.yDotK[1][i2];
                double yDot3 = this.yDotK[2][i2];
                double yDot4 = this.yDotK[3][i2];
                this.interpolatedState[i2] = this.previousState[i2] + coeff1 * yDot1 + coeff2 * yDot2 + coeff3 * yDot3 + coeff4 * yDot4;
                this.interpolatedDerivatives[i2] = coeffDot1 * yDot1 + coeffDot2 * yDot2 + coeffDot3 * yDot3 + coeffDot4 * yDot4;
            }
        } else {
            double s3 = oneMinusThetaH / 6.0;
            double c23 = s3 * (2.0 + twoTheta - fourTheta2);
            double coeff1 = s3 * (1.0 - 5.0 * theta + fourTheta2);
            double coeff2 = c23 * ONE_MINUS_INV_SQRT_2;
            double coeff3 = c23 * ONE_PLUS_INV_SQRT_2;
            double coeff4 = s3 * (1.0 + theta + fourTheta2);
            for (int i3 = 0; i3 < this.interpolatedState.length; ++i3) {
                double yDot1 = this.yDotK[0][i3];
                double yDot2 = this.yDotK[1][i3];
                double yDot3 = this.yDotK[2][i3];
                double yDot4 = this.yDotK[3][i3];
                this.interpolatedState[i3] = this.currentState[i3] - coeff1 * yDot1 - coeff2 * yDot2 - coeff3 * yDot3 - coeff4 * yDot4;
                this.interpolatedDerivatives[i3] = coeffDot1 * yDot1 + coeffDot2 * yDot2 + coeffDot3 * yDot3 + coeffDot4 * yDot4;
            }
        }
    }
}

