/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.admin;

import com.github.tomakehurst.wiremock.admin.Conversions;
import com.github.tomakehurst.wiremock.admin.Paginator;
import com.github.tomakehurst.wiremock.http.Request;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;

public class LimitAndOffsetPaginator<T>
implements Paginator<T> {
    private final List<T> source;
    private final Integer limit;
    private final Integer offset;

    public LimitAndOffsetPaginator(List<T> source, Integer limit, Integer offset) {
        this.source = source;
        Preconditions.checkArgument(limit == null || limit >= 0, "limit must be 0 or greater");
        Preconditions.checkArgument(offset == null || offset >= 0, "offset must be 0 or greater");
        this.limit = limit;
        this.offset = offset;
    }

    public static <T> LimitAndOffsetPaginator<T> fromRequest(List<T> source, Request request) {
        return new LimitAndOffsetPaginator<T>(source, Conversions.toInt(request.queryParameter("limit")), Conversions.toInt(request.queryParameter("offset")));
    }

    @Override
    public List<T> select() {
        int start = MoreObjects.firstNonNull(this.offset, 0);
        int end = Math.min(this.source.size(), start + MoreObjects.firstNonNull(this.limit, this.source.size()));
        return this.source.subList(start, end);
    }

    @Override
    public int getTotal() {
        return this.source.size();
    }

    public static <T> LimitAndOffsetPaginator<T> none(List<T> source) {
        return new LimitAndOffsetPaginator<T>(source, null, null);
    }
}

