/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.client;

import io.micrometer.core.instrument.Timer;
import java.net.SocketAddress;
import java.time.Duration;
import reactor.netty.Metrics;
import reactor.netty.channel.MeterKey;
import reactor.netty.http.MicrometerHttpMetricsRecorder;
import reactor.netty.http.client.HttpClientMetricsRecorder;

final class MicrometerHttpClientMetricsRecorder
extends MicrometerHttpMetricsRecorder
implements HttpClientMetricsRecorder {
    static final MicrometerHttpClientMetricsRecorder INSTANCE = new MicrometerHttpClientMetricsRecorder();

    private MicrometerHttpClientMetricsRecorder() {
        super("reactor.netty.http.client", "http");
    }

    @Override
    public void recordDataReceivedTime(SocketAddress remoteAddress, String uri, String method2, String status, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer dataReceivedTime = this.dataReceivedTimeCache.computeIfAbsent(new MeterKey(uri, address, method2, status), key -> this.dataReceivedTimeBuilder.tags(new String[]{"remote.address", address, "uri", uri, "method", method2, "status", status}).register(Metrics.REGISTRY));
        dataReceivedTime.record(time);
    }

    @Override
    public void recordDataSentTime(SocketAddress remoteAddress, String uri, String method2, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer dataSentTime = this.dataSentTimeCache.computeIfAbsent(new MeterKey(uri, address, method2, null), key -> this.dataSentTimeBuilder.tags(new String[]{"remote.address", address, "uri", uri, "method", method2}).register(Metrics.REGISTRY));
        dataSentTime.record(time);
    }

    @Override
    public void recordResponseTime(SocketAddress remoteAddress, String uri, String method2, String status, Duration time) {
        String address = Metrics.formatSocketAddress(remoteAddress);
        Timer responseTime = this.responseTimeCache.computeIfAbsent(new MeterKey(uri, address, method2, status), key -> this.responseTimeBuilder.tags(new String[]{"remote.address", address, "uri", uri, "method", method2, "status", status}).register(Metrics.REGISTRY));
        responseTime.record(time);
    }
}

