/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import org.reactivestreams.Publisher;
import reactivefeign.client.DelegatingReactiveHttpResponse;
import reactivefeign.client.ReactiveHttpResponse;
import reactivefeign.client.ReactiveHttpResponseMapper;
import reactivefeign.client.statushandler.ReactiveStatusHandler;
import reactivefeign.client.statushandler.ReactiveStatusHandlers;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StatusHandlerPostProcessor
implements ReactiveHttpResponseMapper {
    private final ReactiveStatusHandler statusHandler;
    private static final ReactiveStatusHandler defaultStatusHandler = ReactiveStatusHandlers.defaultFeignErrorDecoder();

    public static StatusHandlerPostProcessor handleStatus(ReactiveStatusHandler statusHandler) {
        return new StatusHandlerPostProcessor(statusHandler);
    }

    private StatusHandlerPostProcessor(ReactiveStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    @Override
    public Mono<ReactiveHttpResponse> apply(ReactiveHttpResponse response) {
        String methodTag = response.request().methodKey();
        ReactiveHttpResponse errorResponse = response;
        if (this.statusHandler.shouldHandle(response.status())) {
            errorResponse = new ErrorReactiveHttpResponse(response, this.statusHandler.decode(methodTag, response));
        } else if (defaultStatusHandler.shouldHandle(response.status())) {
            errorResponse = new ErrorReactiveHttpResponse(response, defaultStatusHandler.decode(methodTag, response));
        }
        return Mono.just(errorResponse);
    }

    private class ErrorReactiveHttpResponse
    extends DelegatingReactiveHttpResponse {
        private final Mono<? extends Throwable> error;

        ErrorReactiveHttpResponse(ReactiveHttpResponse response, Mono<? extends Throwable> error) {
            super(response);
            this.error = error;
        }

        public Publisher<Object> body() {
            if (this.getResponse().body() instanceof Mono) {
                return this.error.flatMap(Mono::error);
            }
            return this.error.flatMapMany(Flux::error);
        }
    }
}

