/*
 * Decompiled with CFR 0.152.
 */
package reactivefeign.client;

import java.util.function.Function;
import reactivefeign.client.ReactiveHttpClient;
import reactivefeign.client.ReactiveHttpRequest;
import reactivefeign.client.ReactiveHttpResponse;
import reactor.core.publisher.Mono;

public interface ReactiveHttpExchangeFilterFunction {
    public Mono<ReactiveHttpResponse> filter(ReactiveHttpRequest var1, ReactiveHttpClient var2);

    default public ReactiveHttpExchangeFilterFunction then(ReactiveHttpExchangeFilterFunction afterFilter) {
        return (request, next) -> this.filter(request, afterRequest -> afterFilter.filter(afterRequest, next));
    }

    default public ReactiveHttpClient filter(ReactiveHttpClient exchangeFunction) {
        return request -> this.filter(request, exchangeFunction);
    }

    public static ReactiveHttpExchangeFilterFunction ofRequestProcessor(Function<ReactiveHttpRequest, Mono<ReactiveHttpRequest>> processor) {
        return (request, next) -> ((Mono)processor.apply(request)).flatMap(next::executeRequest);
    }

    public static ReactiveHttpExchangeFilterFunction ofResponseProcessor(Function<ReactiveHttpResponse, Mono<ReactiveHttpResponse>> processor) {
        return (request, next) -> next.executeRequest(request).flatMap(processor);
    }
}

