/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.net.URI;
import java.util.function.Supplier;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.ReactorNettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.netty.http.server.HttpServerResponse;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;

public class ReactorNettyRequestUpgradeStrategy
implements RequestUpgradeStrategy {
    private int maxFramePayloadLength = 65536;
    private boolean handlePing = false;

    public void setMaxFramePayloadLength(Integer maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public int getMaxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public void setHandlePing(boolean handlePing) {
        this.handlePing = handlePing;
    }

    public boolean getHandlePing() {
        return this.handlePing;
    }

    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange2, WebSocketHandler handler, @Nullable String subProtocol, Supplier<HandshakeInfo> handshakeInfoFactory) {
        ServerHttpResponse response = exchange2.getResponse();
        HttpServerResponse reactorResponse = ReactorNettyRequestUpgradeStrategy.getNativeResponse(response);
        HandshakeInfo handshakeInfo = handshakeInfoFactory.get();
        NettyDataBufferFactory bufferFactory = (NettyDataBufferFactory)response.bufferFactory();
        return response.setComplete().then(Mono.defer(() -> reactorResponse.sendWebsocket(subProtocol, this.maxFramePayloadLength, this.handlePing, (in, out) -> {
            ReactorNettyWebSocketSession session = new ReactorNettyWebSocketSession((WebsocketInbound)in, (WebsocketOutbound)out, handshakeInfo, bufferFactory, this.maxFramePayloadLength);
            URI uri = exchange2.getRequest().getURI();
            return handler.handle(session).checkpoint(uri + " [ReactorNettyRequestUpgradeStrategy]");
        })));
    }

    private static HttpServerResponse getNativeResponse(ServerHttpResponse response) {
        if (response instanceof AbstractServerHttpResponse) {
            return (HttpServerResponse)((AbstractServerHttpResponse)response).getNativeResponse();
        }
        if (response instanceof ServerHttpResponseDecorator) {
            return ReactorNettyRequestUpgradeStrategy.getNativeResponse(((ServerHttpResponseDecorator)response).getDelegate());
        }
        throw new IllegalArgumentException("Couldn't find native response in " + response.getClass().getName());
    }
}

