/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseCookie;
import org.springframework.http.client.reactive.ClientHttpResponse;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import reactor.core.publisher.Flux;
import reactor.netty.NettyInbound;
import reactor.netty.http.client.HttpClientResponse;

class ReactorClientHttpResponse
implements ClientHttpResponse {
    private final NettyDataBufferFactory bufferFactory;
    private final HttpClientResponse response;
    private final NettyInbound inbound;
    private final AtomicBoolean rejectSubscribers = new AtomicBoolean();

    public ReactorClientHttpResponse(HttpClientResponse response, NettyInbound inbound, ByteBufAllocator alloc) {
        this.response = response;
        this.inbound = inbound;
        this.bufferFactory = new NettyDataBufferFactory(alloc);
    }

    @Override
    public Flux<DataBuffer> getBody() {
        return this.inbound.receive().doOnSubscribe(s -> {
            if (this.rejectSubscribers.get()) {
                throw new IllegalStateException("The client response body can only be consumed once.");
            }
        }).doOnCancel(() -> this.rejectSubscribers.set(true)).map(byteBuf -> {
            byteBuf.retain();
            return this.bufferFactory.wrap((ByteBuf)byteBuf);
        });
    }

    @Override
    public HttpHeaders getHeaders() {
        HttpHeaders headers2 = new HttpHeaders();
        this.response.responseHeaders().entries().forEach(e -> headers2.add((String)e.getKey(), (String)e.getValue()));
        return headers2;
    }

    @Override
    public HttpStatus getStatusCode() {
        return HttpStatus.valueOf(this.getRawStatusCode());
    }

    @Override
    public int getRawStatusCode() {
        return this.response.status().code();
    }

    @Override
    public MultiValueMap<String, ResponseCookie> getCookies() {
        LinkedMultiValueMap result = new LinkedMultiValueMap();
        this.response.cookies().values().stream().flatMap(Collection::stream).forEach(cookie -> result.add(cookie.name(), ResponseCookie.from(cookie.name(), cookie.value()).domain(cookie.domain()).path(cookie.path()).maxAge(cookie.maxAge()).secure(cookie.isSecure()).httpOnly(cookie.isHttpOnly()).build()));
        return CollectionUtils.unmodifiableMultiValueMap(result);
    }

    public String toString() {
        return "ReactorClientHttpResponse{request=[" + this.response.method().name() + " " + this.response.uri() + "],status=" + this.getRawStatusCode() + '}';
    }
}

