/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.io.CyclicTimeout;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class TimeoutCompleteListener
extends CyclicTimeout
implements Response.CompleteListener {
    private static final Logger LOG = Log.getLogger(TimeoutCompleteListener.class);
    private final AtomicReference<Request> request = new AtomicReference();

    public TimeoutCompleteListener(Scheduler scheduler) {
        super(scheduler);
    }

    @Override
    public void onTimeoutExpired() {
        Request request = this.request.getAndSet(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total timeout {} ms elapsed for {} on {}", request.getTimeout(), request, this);
        }
        if (request != null) {
            request.abort(new TimeoutException("Total timeout " + request.getTimeout() + " ms elapsed"));
        }
    }

    @Override
    public void onComplete(Result result) {
        Request request = this.request.getAndSet(null);
        if (request != null) {
            boolean cancelled = this.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled ({}) timeout for {} on {}", cancelled, request, this);
            }
        }
    }

    void schedule(HttpRequest request, long timeoutAt) {
        if (this.request.compareAndSet(null, request)) {
            long delay = timeoutAt - System.nanoTime();
            if (delay <= 0L) {
                this.onTimeoutExpired();
            } else {
                this.schedule(delay, TimeUnit.NANOSECONDS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduled timeout in {} ms for {} on {}", TimeUnit.NANOSECONDS.toMillis(delay), request, this);
                }
            }
        }
    }
}

