/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import junit.framework.Assert;
import org.custommonkey.xmlunit.DoctypeInputStream;
import org.custommonkey.xmlunit.DoctypeReader;
import org.custommonkey.xmlunit.NodeInputStream;
import org.custommonkey.xmlunit.exceptions.ConfigurationException;
import org.custommonkey.xmlunit.exceptions.XMLUnitRuntimeException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import org.xmlunit.XMLUnitException;
import org.xmlunit.validation.ParsingValidator;
import org.xmlunit.validation.ValidationProblem;
import org.xmlunit.validation.ValidationResult;

public class Validator
extends DefaultHandler {
    private final InputSource validationInputSource;
    private final StringBuilder messages = new StringBuilder();
    private final boolean usingDoctypeReader;
    private final String systemId;
    private Object schemaSource;
    private boolean useSchema = false;
    private Boolean isValid = null;

    protected Validator(InputSource inputSource, String systemId, boolean usingDoctypeReader) {
        this.validationInputSource = inputSource;
        this.systemId = systemId;
        this.usingDoctypeReader = usingDoctypeReader;
    }

    public Validator(Document document, String systemID, String doctype) {
        this(new InputStreamReader(new NodeInputStream(document)), systemID, doctype);
    }

    public Validator(Reader readerForValidation) {
        this(readerForValidation, null);
    }

    public Validator(String stringForValidation) {
        this(new StringReader(stringForValidation));
    }

    public Validator(InputSource sourceForValidation) {
        this(sourceForValidation, null);
    }

    public Validator(Reader readerForValidation, String systemID) {
        this(new InputSource(readerForValidation), systemID, readerForValidation instanceof DoctypeReader);
    }

    public Validator(String stringForValidation, String systemID) {
        this(new StringReader(stringForValidation), systemID);
    }

    public Validator(InputSource sourceForValidation, String systemID) {
        this(sourceForValidation, systemID, false);
    }

    public Validator(InputSource sourceForValidation, String systemID, String doctype) {
        this(sourceForValidation.getCharacterStream() != null ? new InputSource(new DoctypeReader(sourceForValidation.getCharacterStream(), doctype, systemID)) : new InputSource(new DoctypeInputStream(sourceForValidation.getByteStream(), sourceForValidation.getEncoding(), doctype, systemID)), systemID, true);
    }

    public Validator(Reader readerForValidation, String systemID, String doctype) {
        this(readerForValidation instanceof DoctypeReader ? readerForValidation : new DoctypeReader(readerForValidation, doctype, systemID), systemID);
    }

    public void useXMLSchema(boolean use) {
        this.useSchema = use;
    }

    public boolean isValid() {
        this.validate();
        return this.isValid;
    }

    public void assertIsValid() {
        if (!this.isValid()) {
            Assert.fail((String)this.messages.toString());
        }
    }

    private StringBuilder appendMessage(StringBuilder toAppendTo) {
        if (this.isValid()) {
            return toAppendTo.append("[valid]");
        }
        return toAppendTo.append((CharSequence)this.messages);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString()).append(':');
        return this.appendMessage(builder).toString();
    }

    private void validate() {
        if (this.isValid != null) {
            return;
        }
        ParsingValidator v = new ParsingValidator(this.useSchema ? "http://www.w3.org/2001/XMLSchema" : "http://www.w3.org/TR/REC-xml");
        ArrayList<Source> schemaSourceList = new ArrayList<Source>();
        if (this.systemId != null) {
            schemaSourceList.add(new StreamSource(this.systemId));
        }
        Validator.addSchemaSources(this.schemaSource, schemaSourceList);
        v.setSchemaSources(schemaSourceList.toArray(new Source[0]));
        try {
            ValidationResult r = v.validateInstance(new SAXSource(this.validationInputSource));
            this.isValid = r.isValid() ? Boolean.TRUE : Boolean.FALSE;
            for (ValidationProblem p : r.getProblems()) {
                this.validationProblem(p);
            }
        }
        catch (org.xmlunit.ConfigurationException e) {
            throw new ConfigurationException(e.getCause());
        }
        catch (XMLUnitException e) {
            throw new XMLUnitRuntimeException(e.getMessage(), e.getCause());
        }
        if (this.usingDoctypeReader && this.isValid == Boolean.FALSE) {
            try {
                this.messages.append("\nContent was: ").append(Validator.getOriginalContent(this.validationInputSource));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void validationProblem(ValidationProblem p) {
        String msg = "At line " + p.getLine() + ", column: " + p.getColumn() + " ==> " + p.getMessage();
        if (!msg.endsWith("\n")) {
            msg = msg + "\n";
        }
        this.invalidate(msg);
    }

    private void invalidate(String message) {
        this.isValid = Boolean.FALSE;
        this.messages.append(message).append(' ');
    }

    public void setJAXP12SchemaSource(Object schemaSource) {
        this.schemaSource = schemaSource;
    }

    private static void addSchemaSources(Object schemaSources, List<Source> targetList) {
        if (schemaSources instanceof String) {
            targetList.add(new StreamSource((String)schemaSources));
        } else if (schemaSources instanceof File) {
            targetList.add(new StreamSource((File)schemaSources));
        } else if (schemaSources instanceof InputStream) {
            targetList.add(new StreamSource((InputStream)schemaSources));
        } else if (schemaSources instanceof InputSource) {
            targetList.add(new SAXSource((InputSource)schemaSources));
        } else if (schemaSources instanceof Object[]) {
            for (Object s : (Object[])schemaSources) {
                Validator.addSchemaSources(s, targetList);
            }
        } else if (schemaSources != null) {
            throw new XMLUnitRuntimeException("Unknown schema source type: " + schemaSources.getClass());
        }
    }

    private static String getOriginalContent(InputSource s) throws IOException {
        return s.getCharacterStream() instanceof DoctypeReader ? ((DoctypeReader)s.getCharacterStream()).getContent() : ((DoctypeInputStream)s.getByteStream()).getContent(s.getEncoding());
    }
}

