/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.internal;

import com.pinterest.ktlint.cli.internal.FileUtilsKt;
import com.pinterest.ktlint.logger.api.KtLintKLoggerInitializerKt;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.util.UtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\b\b\u0002\u0010\u0014\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0015\u001a\u00020\u0003*\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0002\u001a(\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\r*\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\r2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u001a\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\r*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0003H\u0002\u001a\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b*\u0004\u0018\u00010\u0007H\u0002\u001a\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u0007*\u0004\u0018\u00010\u0007H\u0002\u001a\u0012\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\r*\u00020\u0003H\u0002\u001a\f\u0010\u001c\u001a\u00020\u0007*\u00020\u0007H\u0000\u001a\u0014\u0010!\u001a\u00020\u0007*\u00020\"2\u0006\u0010#\u001a\u00020\u001eH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006$"}, d2={"LOGGER", "Lio/github/oshai/kotlinlogging/KLogger;", "ROOT_DIR_PATH", "Ljava/nio/file/Path;", "TILDE_REGEX", "Lkotlin/text/Regex;", "NEGATION_PREFIX", "", "USER_HOME", "kotlin.jvm.PlatformType", "DEFAULT_KOTLIN_FILE_EXTENSIONS", "", "DEFAULT_PATTERNS", "", "getDEFAULT_PATTERNS", "()Ljava/util/List;", "fileSequence", "Lkotlin/sequences/Sequence;", "Ljava/nio/file/FileSystem;", "patterns", "rootDir", "findCommonParentDir", "path", "expand", "toGlob", "expandDoubleStarPatterns", "normalizeWindowsPattern", "expandPathToDefaultPatterns", "expandTildeToFullPath", "onWindowsOS", "", "getOnWindowsOS", "()Z", "location", "Ljava/io/File;", "relative", "ktlint-cli"})
@SourceDebugExtension(value={"SMAP\nFileUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtils.kt\ncom/pinterest/ktlint/cli/internal/FileUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,379:1\n3301#2,10:380\n1634#2,3:390\n774#2:393\n865#2,2:394\n1563#2:396\n1634#2,3:397\n827#2:400\n855#2,2:401\n1869#2,2:403\n1563#2:405\n1634#2,3:406\n1617#2,9:412\n1869#2:421\n1870#2:423\n1626#2:424\n1563#2:425\n1634#2,3:426\n1563#2:429\n1634#2,3:430\n1374#2:433\n1460#2,5:434\n1563#2:439\n1634#2,3:440\n1563#2:443\n1634#2,3:444\n774#2:447\n865#2,2:448\n827#2:450\n855#2,2:451\n1869#2:453\n774#2:454\n865#2,2:455\n1870#2:457\n827#2:458\n855#2,2:459\n1869#2,2:461\n1374#2:463\n1460#2,5:464\n1563#2:469\n1634#2,3:470\n29#3,3:409\n1#4:422\n*S KotlinDebug\n*F\n+ 1 FileUtils.kt\ncom/pinterest/ktlint/cli/internal/FileUtilsKt\n*L\n51#1:380,10\n59#1:390,3\n70#1:393\n70#1:394,2\n71#1:396\n71#1:397,3\n75#1:400\n75#1:401,2\n90#1:403,2\n102#1:405\n102#1:406,3\n175#1:412,9\n175#1:421\n175#1:423\n175#1:424\n181#1:425\n181#1:426,3\n182#1:429\n182#1:430,3\n195#1:433\n195#1:434,5\n243#1:439\n243#1:440,3\n261#1:443\n261#1:444,3\n273#1:447\n273#1:448,2\n274#1:450\n274#1:451,2\n281#1:453\n287#1:454\n287#1:455,2\n281#1:457\n302#1:458\n302#1:459,2\n305#1:461,2\n336#1:463\n336#1:464,5\n33#1:469\n33#1:470,3\n106#1:409,3\n175#1:422\n*E\n"})
public final class FileUtilsKt {
    @NotNull
    private static final KLogger LOGGER;
    @NotNull
    private static final Path ROOT_DIR_PATH;
    @NotNull
    private static final Regex TILDE_REGEX;
    @NotNull
    private static final String NEGATION_PREFIX = "!";
    private static final String USER_HOME;
    @NotNull
    private static final Set<String> DEFAULT_KOTLIN_FILE_EXTENSIONS;
    @NotNull
    private static final List<String> DEFAULT_PATTERNS;

    @NotNull
    public static final List<String> getDEFAULT_PATTERNS() {
        return DEFAULT_PATTERNS;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Sequence<Path> fileSequence(@NotNull FileSystem $this$fileSequence, @NotNull List<String> patterns, @NotNull Path rootDir) {
        void $this$mapTo$iv$iv;
        List list;
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        void $this$mapTo$iv$iv2;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        Object item$iv2;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)$this$fileSequence, (String)"<this>");
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        if (patterns.isEmpty()) {
            LOGGER.trace(FileUtilsKt::fileSequence$lambda$2);
            return SequencesKt.emptySequence();
        }
        List result = new ArrayList();
        Iterable $this$partition$iv = patterns;
        boolean $i$f$partition = false;
        Iterable<Object> first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            boolean bl;
            String it2 = (String)element$iv;
            boolean bl2 = false;
            try {
                bl = Files.isRegularFile(rootDir.resolve(it2), new LinkOption[0]);
            }
            catch (InvalidPathException invalidPathException) {
                bl = false;
            }
            boolean bl3 = bl ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List existingFiles = (List)pair.component1();
        List patternsExclusiveExistingFiles = (List)pair.component2();
        first$iv = existingFiles;
        Collection destination$iv = result;
        boolean $i$f$mapTo22 = false;
        for (Object item$iv2 : $this$mapTo$iv) {
            void it3;
            String bl2 = (String)item$iv2;
            collection = destination$iv;
            boolean bl = false;
            collection.add(rootDir.resolve((String)it3));
        }
        if (!((Collection)result).isEmpty() && patternsExclusiveExistingFiles.isEmpty()) {
            return CollectionsKt.asSequence((Iterable)result);
        }
        List<String> globs = FileUtilsKt.expand($this$fileSequence, patternsExclusiveExistingFiles, rootDir);
        Iterable $i$f$mapTo22 = globs;
        boolean $i$f$filter = false;
        item$iv2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)NEGATION_PREFIX, (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add($this$fileSequence.getPathMatcher(StringsKt.removePrefix((String)it, (CharSequence)NEGATION_PREFIX)));
        }
        List negatedPathMatchers = (List)destination$iv$iv;
        Iterable $i$f$map22 = globs;
        boolean $i$f$filterNot = false;
        destination$iv$iv = $this$filterNot$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            String it4 = (String)element$iv$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)it4, (String)NEGATION_PREFIX, (boolean)false, (int)2, null)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List includeMatchers = (List)destination$iv$iv2;
        boolean bl = false;
        if (!((Collection)negatedPathMatchers).isEmpty() && includeMatchers.isEmpty()) {
            LOGGER.info(FileUtilsKt::fileSequence$lambda$9$lambda$8);
            list = CollectionsKt.plus((Collection)includeMatchers, (Iterable)FileUtilsKt.expand($this$fileSequence, DEFAULT_PATTERNS, rootDir));
        } else {
            list = includeMatchers;
        }
        List includeGlobs = list;
        Ref.ObjectRef commonRootDir = new Ref.ObjectRef();
        commonRootDir.element = rootDir;
        Iterable $this$forEach$iv = patterns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String pattern = (String)element$iv;
            boolean bl4 = false;
            try {
                Path patternDir = rootDir.resolve(pattern).normalize();
                Path path = (Path)commonRootDir.element;
                Intrinsics.checkNotNull((Object)patternDir);
                commonRootDir.element = FileUtilsKt.findCommonParentDir(path, patternDir);
            }
            catch (InvalidPathException patternDir) {
            }
        }
        Iterable $this$map$iv2 = includeGlobs;
        boolean $i$f$map = false;
        Iterable element$iv = $this$map$iv2;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it5;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv3;
            boolean bl5 = false;
            collection.add($this$fileSequence.getPathMatcher((String)it5));
        }
        List pathMatchers = (List)destination$iv$iv3;
        LOGGER.debug(() -> FileUtilsKt.fileSequence$lambda$12(commonRootDir));
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl6 = false;
        Files.walkFileTree((Path)commonRootDir.element, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>((List<? extends PathMatcher>)negatedPathMatchers, (List<? extends PathMatcher>)pathMatchers, (List<Path>)result, (Ref.ObjectRef<Path>)commonRootDir){
            final /* synthetic */ List<PathMatcher> $negatedPathMatchers;
            final /* synthetic */ List<PathMatcher> $pathMatchers;
            final /* synthetic */ List<Path> $result;
            final /* synthetic */ Ref.ObjectRef<Path> $commonRootDir;
            {
                this.$negatedPathMatchers = $negatedPathMatchers;
                this.$pathMatchers = $pathMatchers;
                this.$result = $result;
                this.$commonRootDir = $commonRootDir;
            }

            /*
             * Enabled aggressive block sorting
             */
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes fileAttrs) {
                PathMatcher it;
                boolean bl;
                Path path;
                block11: {
                    Path path2;
                    Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
                    Intrinsics.checkNotNullParameter((Object)fileAttrs, (String)"fileAttrs");
                    if (FileUtilsKt.access$getOnWindowsOS()) {
                        Path path3;
                        Path it2 = path3 = Paths.get(StringsKt.replace$default((String)((Object)filePath.toAbsolutePath()).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), new String[0]);
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it2, (Object)filePath)) {
                            FileUtilsKt.access$getLOGGER$p().trace(() -> fileSequence.duration.1.1.visitFile$lambda$1$lambda$0(filePath, it2));
                        }
                        path2 = path3;
                    } else {
                        path2 = filePath;
                    }
                    path = path2;
                    Iterable $this$none$iv = this.$negatedPathMatchers;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (T element$iv : $this$none$iv) {
                            it = (PathMatcher)element$iv;
                            boolean bl3 = false;
                            if (!it.matches(path)) continue;
                            bl = false;
                            break block11;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    boolean bl4;
                    block12: {
                        Iterable $this$any$iv = this.$pathMatchers;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                it = (PathMatcher)element$iv;
                                boolean bl5 = false;
                                if (!it.matches(path)) continue;
                                bl4 = true;
                                break block12;
                            }
                            bl4 = false;
                        }
                    }
                    if (bl4) {
                        FileUtilsKt.access$getLOGGER$p().trace(() -> fileSequence.duration.1.1.visitFile$lambda$5(path, this.$pathMatchers));
                        Intrinsics.checkNotNull((Object)path);
                        this.$result.add(path);
                        return FileVisitResult.CONTINUE;
                    }
                }
                FileUtilsKt.access$getLOGGER$p().trace(() -> fileSequence.duration.1.1.visitFile$lambda$6(path));
                return FileVisitResult.CONTINUE;
            }

            public FileVisitResult preVisitDirectory(Path dirPath, BasicFileAttributes dirAttr) {
                FileVisitResult fileVisitResult;
                Intrinsics.checkNotNullParameter((Object)dirPath, (String)"dirPath");
                Intrinsics.checkNotNullParameter((Object)dirAttr, (String)"dirAttr");
                if (Files.isHidden(dirPath)) {
                    if (Intrinsics.areEqual((Object)dirPath, (Object)this.$commonRootDir.element)) {
                        FileUtilsKt.access$getLOGGER$p().trace(() -> fileSequence.duration.1.1.preVisitDirectory$lambda$7(dirPath));
                        fileVisitResult = FileVisitResult.CONTINUE;
                    } else {
                        FileUtilsKt.access$getLOGGER$p().trace(() -> fileSequence.duration.1.1.preVisitDirectory$lambda$8(dirPath));
                        fileVisitResult = FileVisitResult.SKIP_SUBTREE;
                    }
                } else {
                    FileUtilsKt.access$getLOGGER$p().trace(() -> fileSequence.duration.1.1.preVisitDirectory$lambda$9(dirPath));
                    fileVisitResult = FileVisitResult.CONTINUE;
                }
                return fileVisitResult;
            }

            private static final Object visitFile$lambda$1$lambda$0(Path $filePath, Path $it) {
                return "On WindowsOS transform '" + $filePath + "' to '" + $it + '\'';
            }

            /*
             * WARNING - void declaration
             */
            private static final Object visitFile$lambda$5(Path $path, List $pathMatchers) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = $pathMatchers;
                StringBuilder stringBuilder = new StringBuilder().append("- File: ").append($path).append(": Include as it matches patterns ");
                boolean $i$f$filter = false;
                void var4_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    PathMatcher it = (PathMatcher)element$iv$iv;
                    boolean bl = false;
                    if (!it.matches($path)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return stringBuilder.append((List)destination$iv$iv).toString();
            }

            private static final Object visitFile$lambda$6(Path $path) {
                return "- File: " + $path + ": Ignore";
            }

            private static final Object preVisitDirectory$lambda$7(Path $dirPath) {
                return "- Dir: " + $dirPath + ": Traverse started from hidden directory";
            }

            private static final Object preVisitDirectory$lambda$8(Path $dirPath) {
                return "- Dir: " + $dirPath + ": Ignore traversal of hidden directory";
            }

            private static final Object preVisitDirectory$lambda$9(Path $dirPath) {
                return "- Dir: " + $dirPath + ": Traverse";
            }
        });
        long duration2 = System.currentTimeMillis() - start$iv;
        LOGGER.debug(() -> FileUtilsKt.fileSequence$lambda$14(result, duration2));
        return CollectionsKt.asSequence((Iterable)result);
    }

    public static /* synthetic */ Sequence fileSequence$default(FileSystem fileSystem, List list, Path path, int n, Object object) {
        if ((n & 2) != 0) {
            Path path2 = Paths.get(".", new String[0]).toAbsolutePath().normalize();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
            path = path2;
        }
        return FileUtilsKt.fileSequence(fileSystem, list, path);
    }

    private static final Path findCommonParentDir(Path $this$findCommonParentDir, Path path) {
        Path path2;
        if (path.startsWith($this$findCommonParentDir)) {
            path2 = $this$findCommonParentDir;
        } else if ($this$findCommonParentDir.startsWith(path)) {
            path2 = path;
        } else {
            Path path3 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
            path2 = FileUtilsKt.findCommonParentDir($this$findCommonParentDir, path3);
        }
        return path2;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> expand(FileSystem $this$expand, List<String> patterns, Path rootDir) {
        void $this$flatMapTo$iv$iv;
        String it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = patterns;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            if ((FileUtilsKt.getOnWindowsOS() ? FileUtilsKt.normalizeWindowsPattern(it2) : it2) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(FileUtilsKt.expandTildeToFullPath(it));
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (FileUtilsKt.getOnWindowsOS()) {
                String string2;
                String string3 = File.separator;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"separator");
                String transformedPath = string2 = StringsKt.replace$default((String)it, (String)string3, (String)"/", (boolean)false, (int)4, null);
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)transformedPath)) {
                    LOGGER.trace(() -> FileUtilsKt.expand$lambda$19$lambda$18$lambda$17(it, transformedPath));
                }
                string = string2;
            } else {
                string = it;
            }
            collection.add(string);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String path = (String)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = FileUtilsKt.toGlob($this$expand, path, rootDir);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> toGlob(FileSystem $this$toGlob, String path, Path rootDir) {
        String originalPattern;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection<String> it;
        Iterable<Path> resolvedPath;
        String negation = StringsKt.startsWith$default((String)path, (String)NEGATION_PREFIX, (boolean)false, (int)2, null) ? NEGATION_PREFIX : "";
        String pathWithoutNegationPrefix = StringsKt.removePrefix((String)path, (CharSequence)NEGATION_PREFIX);
        try {
            Collection collection2;
            Collection<String> collection3;
            resolvedPath = rootDir.resolve(pathWithoutNegationPrefix).normalize();
            Intrinsics.checkNotNull((Object)resolvedPath);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.isDirectory((Path)resolvedPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                collection3 = FileUtilsKt.expandPathToDefaultPatterns((Path)resolvedPath);
                it = collection3;
                boolean bl = false;
                LOGGER.trace(() -> FileUtilsKt.toGlob$lambda$22$lambda$21(resolvedPath, it));
                collection2 = collection3;
            } else {
                collection3 = FileUtilsKt.expandDoubleStarPatterns(resolvedPath.toString());
                it = collection3;
                boolean bl = false;
                LOGGER.trace(() -> FileUtilsKt.toGlob$lambda$24$lambda$23(resolvedPath, it));
                collection2 = collection3;
            }
            resolvedPath = collection2;
        }
        catch (InvalidPathException invalidPathException) {
            Collection collection4;
            if (FileUtilsKt.getOnWindowsOS()) {
                Set<String> it2 = it = FileUtilsKt.expandDoubleStarPatterns(pathWithoutNegationPrefix);
                boolean bl = false;
                LOGGER.trace(() -> FileUtilsKt.toGlob$lambda$26$lambda$25(pathWithoutNegationPrefix, it2));
                collection4 = it;
            } else {
                collection4 = CollectionsKt.emptyList();
            }
            resolvedPath = collection4;
        }
        Iterable<Path> expandedPatterns = resolvedPath;
        resolvedPath = expandedPatterns;
        boolean $i$f$map = false;
        it = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            String string2 = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            if (FileUtilsKt.getOnWindowsOS()) {
                String string3;
                String string4 = $this$toGlob.getSeparator();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getSeparator(...)");
                String transformedPattern = string3 = UtilKt.prefixIfNot((String)StringsKt.removePrefix((String)StringsKt.substringAfter$default((String)StringsKt.replace$default((String)originalPattern, (String)string4, (String)"/", (boolean)false, (int)4, null), (String)":", null, (int)2, null), (CharSequence)"/"), (String)"**/");
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)transformedPattern, (Object)originalPattern)) {
                    LOGGER.trace(() -> FileUtilsKt.toGlob$lambda$29$lambda$28$lambda$27(originalPattern, transformedPattern));
                }
                string = string3;
            } else {
                string = originalPattern;
            }
            collection.add(string);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            originalPattern = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(negation + "glob:" + (String)it3);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<String> expandDoubleStarPatterns(String $this$expandDoubleStarPatterns) {
        void $this$filterNotTo$iv$iv;
        String it;
        Iterable $this$filterTo$iv$iv;
        List list;
        List list2;
        Object[] objectArray = new String[]{$this$expandDoubleStarPatterns};
        Set paths = SetsKt.mutableSetOf((Object[])objectArray);
        String string = $this$expandDoubleStarPatterns;
        if (string != null) {
            String[] stringArray = new String[]{"/"};
            list2 = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        List parts = list;
        Iterable $this$filter$iv = parts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)"**")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl3 = false;
            if (it == CollectionsKt.last((List)parts)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            String doubleStarPart = (String)element$iv;
            boolean bl = false;
            String $this$expandDoubleStarPatterns_u24lambda_u2435_u24lambda_u2434 = $this$expandDoubleStarPatterns;
            boolean bl2 = false;
            Iterable bl3 = parts;
            boolean $i$f$filter2 = false;
            void var13_17 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it2 = (String)element$iv$iv;
                boolean bl4 = false;
                if (!(it2 != doubleStarPart)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            String expandedPath = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            paths.addAll((Collection)FileUtilsKt.expandDoubleStarPatterns(expandedPath));
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)paths));
    }

    /*
     * WARNING - void declaration
     */
    private static final String normalizeWindowsPattern(String $this$normalizeWindowsPattern) {
        String string;
        if (FileUtilsKt.getOnWindowsOS()) {
            String[] stringArray;
            List list;
            String string2;
            Deque parts = new LinkedList();
            if ($this$normalizeWindowsPattern != null && (string2 = StringsKt.replace$default((String)$this$normalizeWindowsPattern, (String)"\\", (String)"/", (boolean)false, (int)4, null)) != null && (list = StringsKt.split$default((CharSequence)string2, (String[])(stringArray = new String[]{"/"}), (boolean)false, (int)0, (int)6, null)) != null) {
                void $this$forEach$iv;
                void $this$filterNotTo$iv$iv;
                Iterable $this$filterNot$iv;
                Iterable iterable = list;
                boolean $i$f$filterNot = false;
                Iterator iterator = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)".")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterNot$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it, (Object)"..")) {
                        if (parts.isEmpty()) {
                            LOGGER.warn(() -> FileUtilsKt.normalizeWindowsPattern$lambda$39$lambda$37($this$normalizeWindowsPattern));
                            return null;
                        }
                        Object e = parts.peekLast();
                        Intrinsics.checkNotNullExpressionValue(e, (String)"peekLast(...)");
                        if (StringsKt.contains$default((CharSequence)((CharSequence)e), (char)'*', (boolean)false, (int)2, null)) {
                            LOGGER.warn(() -> FileUtilsKt.normalizeWindowsPattern$lambda$39$lambda$38($this$normalizeWindowsPattern, parts));
                            return null;
                        }
                        String cfr_ignored_0 = (String)parts.removeLast();
                        continue;
                    }
                    parts.addLast(it);
                }
            }
            string = CollectionsKt.joinToString$default((Iterable)parts, (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
        } else {
            string = $this$normalizeWindowsPattern;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> expandPathToDefaultPatterns(Path $this$expandPathToDefaultPatterns) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = DEFAULT_KOTLIN_FILE_EXTENSIONS;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new String[]{$this$expandPathToDefaultPatterns + "/*." + it, $this$expandPathToDefaultPatterns + "/**/*." + it};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final String expandTildeToFullPath(@NotNull String $this$expandTildeToFullPath) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$expandTildeToFullPath, (String)"<this>");
        if (FileUtilsKt.getOnWindowsOS()) {
            charSequence = $this$expandTildeToFullPath;
        } else {
            CharSequence charSequence2 = $this$expandTildeToFullPath;
            Regex regex = TILDE_REGEX;
            String string = USER_HOME;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"USER_HOME");
            String string2 = string;
            CharSequence it = charSequence2 = regex.replaceFirst(charSequence2, string2);
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)$this$expandTildeToFullPath)) {
                LOGGER.trace(() -> FileUtilsKt.expandTildeToFullPath$lambda$42$lambda$41($this$expandTildeToFullPath, (String)it));
            }
            charSequence = charSequence2;
        }
        return charSequence;
    }

    private static final boolean getOnWindowsOS() {
        String string = System.getProperty("os.name");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        return StringsKt.startsWith((String)string, (String)"windows", (boolean)true);
    }

    @NotNull
    public static final String location(@NotNull File $this$location, boolean relative) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$location, (String)"<this>");
        if (relative) {
            Path path = $this$location.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
            string = StringsKt.replace$default((String)((Object)PathsKt.relativeToOrSelf((Path)path, (Path)ROOT_DIR_PATH)).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        } else {
            String string2 = $this$location.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            string = StringsKt.replace$default((String)string2, (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null);
        }
        return string;
    }

    private static final Unit LOGGER$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object fileSequence$lambda$2() {
        return "No patterns provided. Will not expand any globs.";
    }

    private static final Object fileSequence$lambda$9$lambda$8() {
        return "A negate pattern is specified without an include pattern. As default, the include patterns '" + DEFAULT_PATTERNS + "' are used.";
    }

    private static final Object fileSequence$lambda$12(Ref.ObjectRef $commonRootDir) {
        return "Start walkFileTree from directory: '" + $commonRootDir.element + '\'';
    }

    private static final Object fileSequence$lambda$14(List $result, long $duration) {
        return "Discovered " + ((Collection)$result).size() + " files to be processed in " + $duration + " ms";
    }

    private static final Object expand$lambda$19$lambda$18$lambda$17(String $it, String $transformedPath) {
        return "On WindowsOS transform '" + $it + "' to '" + $transformedPath + '\'';
    }

    private static final Object toGlob$lambda$22$lambda$21(Path $resolvedPath, List $it) {
        return "Expanding resolved directory path '" + $resolvedPath + "' to patterns: [" + $it + ']';
    }

    private static final Object toGlob$lambda$24$lambda$23(Path $resolvedPath, Set $it) {
        return "Expanding resolved path '" + $resolvedPath + "` to patterns: [" + $it + ']';
    }

    private static final Object toGlob$lambda$26$lambda$25(String $pathWithoutNegationPrefix, Set $it) {
        return "On WindowsOS: expanding unresolved path '" + $pathWithoutNegationPrefix + "` to patterns: [" + $it + ']';
    }

    private static final Object toGlob$lambda$29$lambda$28$lambda$27(String $originalPattern, String $transformedPattern) {
        return "On WindowsOS, transform '" + $originalPattern + "' to '" + $transformedPattern + '\'';
    }

    private static final Object normalizeWindowsPattern$lambda$39$lambda$37(String $this_normalizeWindowsPattern) {
        return "On WindowsOS the pattern '" + $this_normalizeWindowsPattern + "' can not be used as it refers to a path outside of the current directory";
    }

    private static final Object normalizeWindowsPattern$lambda$39$lambda$38(String $this_normalizeWindowsPattern, Deque $parts) {
        return "On WindowsOS the pattern '" + $this_normalizeWindowsPattern + "' can not be used as '/..' follows the wildcard pattern " + (String)$parts.peekLast();
    }

    private static final Object expandTildeToFullPath$lambda$42$lambda$41(String $this_expandTildeToFullPath, String $it) {
        return "On non-WindowsOS expand '" + $this_expandTildeToFullPath + "' to '" + $it + '\'';
    }

    public static final /* synthetic */ boolean access$getOnWindowsOS() {
        return FileUtilsKt.getOnWindowsOS();
    }

    public static final /* synthetic */ KLogger access$getLOGGER$p() {
        return LOGGER;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        LOGGER = KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KotlinLogging.INSTANCE.logger(FileUtilsKt::LOGGER$lambda$0));
        Path path = Paths.get("", new String[0]).toAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
        ROOT_DIR_PATH = path;
        TILDE_REGEX = new Regex("^(!)?~");
        USER_HOME = System.getProperty("user.home");
        Object[] objectArray = new String[]{"kt", "kts"};
        DEFAULT_KOTLIN_FILE_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
        Iterable $this$map$iv = DEFAULT_KOTLIN_FILE_EXTENSIONS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("**/*." + (String)it);
        }
        DEFAULT_PATTERNS = (List)var3_3;
    }
}

