/*
 * Decompiled with CFR 0.152.
 */
package com.pinterest.ktlint.cli.internal;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.pinterest.ktlint.cli.internal.FileUtilsKt;
import com.pinterest.ktlint.cli.internal.KtlintCommandLine;
import com.pinterest.ktlint.cli.internal.KtlintCommandLineKt;
import com.pinterest.ktlint.cli.internal.KtlintVersionProvider;
import com.pinterest.ktlint.cli.internal.LoadRuleProvidersKt;
import com.pinterest.ktlint.cli.internal.LogLevelConverter;
import com.pinterest.ktlint.cli.internal.ReporterAggregator;
import com.pinterest.ktlint.cli.reporter.baseline.Baseline;
import com.pinterest.ktlint.cli.reporter.baseline.BaselineErrorHandling;
import com.pinterest.ktlint.cli.reporter.baseline.BaselineKt;
import com.pinterest.ktlint.cli.reporter.core.api.KtlintCliError;
import com.pinterest.ktlint.cli.reporter.core.api.ReporterV2;
import com.pinterest.ktlint.logger.api.KtLintKLoggerInitializerKt;
import com.pinterest.ktlint.rule.engine.api.Code;
import com.pinterest.ktlint.rule.engine.api.EditorConfigDefaults;
import com.pinterest.ktlint.rule.engine.api.EditorConfigOverride;
import com.pinterest.ktlint.rule.engine.api.KtLintParseException;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleEngine;
import com.pinterest.ktlint.rule.engine.api.KtLintRuleException;
import com.pinterest.ktlint.rule.engine.api.LintError;
import com.pinterest.ktlint.rule.engine.core.api.RuleId;
import com.pinterest.ktlint.rule.engine.core.api.RuleProvider;
import com.pinterest.ktlint.rule.engine.core.api.RuleProviderKt;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.CodeStyleValue;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecution;
import com.pinterest.ktlint.rule.engine.core.api.editorconfig.RuleExecutionEditorConfigPropertyKt;
import com.pinterest.ktlint.ruleset.standard.rules.FilenameRuleKt;
import io.github.oshai.kotlinlogging.DelegatingKLogger;
import io.github.oshai.kotlinlogging.KLogger;
import io.github.oshai.kotlinlogging.KotlinLogging;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Deprecated;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=KtlintVersionProvider.class, mixinStandardHelpOptions=true, headerHeading="\nAn anti-bikeshedding Kotlin linter with built-in formatter.\n(https://pinterest.github.io/ktlint/latest/).\n\nUsage:\n  ktlint <flags> [patterns]\n  java -jar ktlint.jar <flags> [patterns]\n\nExamples:\n  # Check the style of all Kotlin files (ending with '.kt' or '.kts') inside the current dir (recursively).\n  #\n  # Hidden folders will be skipped.\n  ktlint\n\n  # Check only certain locations starting from the current directory.\n  #\n  # Prepend ! to negate the pattern, KtLint uses .gitignore pattern style syntax.\n  # Globs are applied starting from the last one.\n  #\n  # Hidden folders will be skipped.\n  # Check all '.kt' files in 'src/' directory, but ignore files ending with 'Test.kt':\n  ktlint \"src/**/*.kt\" \"!src/**/*Test.kt\"\n  # Check all '.kt' files in 'src/' directory, but ignore 'generated' directory and its subdirectories:\n  ktlint \"src/**/*.kt\" \"!src/**/generated/**\"\n\n  # Auto-correct style violations.\n  ktlint -F \"src/**/*.kt\"\n\n  # Using custom reporter jar and overriding report location\n  ktlint --reporter=csv,artifact=/path/to/reporter/csv.jar,output=my-custom-report.csv\nFlags:\n", synopsisHeading="", customSynopsis={""}, sortOptions=false)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010F\u001a\u00020GH\u0002J\r\u0010H\u001a\u00020GH\u0000\u00a2\u0006\u0002\bIJ\u0016\u0010J\u001a\u00020K2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020N0MH\u0002J,\u0010*\u001a\b\u0012\u0004\u0012\u00020O022\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020O02H\u0002J,\u0010U\u001a\b\u0012\u0004\u0012\u00020O022\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020O02H\u0002J2\u0010V\u001a\u00020G2\u0006\u0010P\u001a\u00020Q2\u0018\u0010W\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020O020X2\u0006\u0010Y\u001a\u00020ZH\u0002J\u0018\u0010[\u001a\u00020G2\u0006\u0010P\u001a\u00020Q2\u0006\u0010Y\u001a\u00020ZH\u0002J,\u0010\\\u001a\b\u0012\u0004\u0012\u00020O022\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020S2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020O02H\u0002J\u0016\u0010]\u001a\b\u0012\u0004\u0012\u00020\u00060M2\u0006\u0010^\u001a\u00020\u0006H\u0002J&\u0010_\u001a\u00020G2\u0006\u0010`\u001a\u00020\u00062\f\u0010a\u001a\b\u0012\u0004\u0012\u00020O022\u0006\u0010Y\u001a\u00020ZH\u0002J\u0013\u0010L\u001a\b\u0012\u0004\u0012\u00020N0MH\u0000\u00a2\u0006\u0002\bbJ\u0006\u0010c\u001a\u00020GJ\u0012\u0010d\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020O02H\u0002J<\u0010e\u001a\u00020G\"\u0004\b\u0000\u0010f*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002Hf0h0g2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u0002Hf\u0012\u0004\u0012\u00020G0j2\b\b\u0002\u0010k\u001a\u00020,H\u0002J\u0018\u0010l\u001a\b\u0012\u0004\u0012\u00020\u000602*\b\u0012\u0004\u0012\u00020\u000602H\u0002J\u0018\u0010m\u001a\u00020O*\u00060nj\u0002`o2\u0006\u0010R\u001a\u00020SH\u0002J\u000e\u0010p\u001a\u0004\u0018\u00010q*\u00020AH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\u001a8\u0002@\u0002X\u0083.\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u000f8@@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0011R$\u0010\u001e\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u001f\u0010\u0002\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u0014\u0010\"\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010%\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b&\u0010\u0002\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R\u000e\u0010)\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010*\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010+\u001a\u00020,8B@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0012\u0010/\u001a\u0002008\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u00101\u001a\b\u0012\u0004\u0012\u00020\u0006028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u00103\u001a\u00020\u000f8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u0011\"\u0004\b5\u0010\u0013R\u0018\u00106\u001a\b\u0012\u0004\u0012\u00020\u0006028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R$\u00107\u001a\b\u0012\u0004\u0012\u00020\u0006028\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0012\u0010<\u001a\u00020\u000f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010=\u001a\u0004\u0018\u00010\u00068\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010@\u001a\u0004\u0018\u000100*\u00020A2\b\u0010?\u001a\u0004\u0018\u0001008B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\bB\u0010C\"\u0004\bD\u0010E\u00a8\u0006r"}, d2={"Lcom/pinterest/ktlint/cli/internal/KtlintCommandLine;", "", "()V", "adviseToUseFormat", "Ljava/util/concurrent/atomic/AtomicBoolean;", "baselinePath", "", "codeStyle", "Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "getCodeStyle$annotations", "getCodeStyle", "()Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;", "setCodeStyle", "(Lcom/pinterest/ktlint/rule/engine/core/api/editorconfig/CodeStyleValue;)V", "color", "", "getColor", "()Z", "setColor", "(Z)V", "colorName", "getColorName", "()Ljava/lang/String;", "setColorName", "(Ljava/lang/String;)V", "commandSpec", "Lpicocli/CommandLine$Model$CommandSpec;", "<set-?>", "debug", "getDebug$ktlint_cli", "disabledRules", "getDisabledRules$annotations", "getDisabledRules", "setDisabledRules", "editorConfigPath", "errorNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "experimental", "getExperimental$annotations", "getExperimental", "setExperimental", "fileNumber", "format", "limit", "", "getLimit", "()I", "minLogLevel", "Lch/qos/logback/classic/Level;", "patterns", "", "relative", "getRelative", "setRelative", "reporterConfigurations", "rulesetJarPaths", "getRulesetJarPaths", "()Ljava/util/List;", "setRulesetJarPaths", "(Ljava/util/List;)V", "stdin", "stdinDelimiter", "tripped", "value", "level", "Lio/github/oshai/kotlinlogging/KLogger;", "getLevel", "(Lio/github/oshai/kotlinlogging/KLogger;)Lch/qos/logback/classic/Level;", "setLevel", "(Lio/github/oshai/kotlinlogging/KLogger;Lch/qos/logback/classic/Level;)V", "assertStdinAndPatternsFromStdinOptionsMutuallyExclusive", "", "configureLogger", "configureLogger$ktlint_cli", "editorConfigDefaults", "Lcom/pinterest/ktlint/rule/engine/api/EditorConfigDefaults;", "ruleProviders", "", "Lcom/pinterest/ktlint/rule/engine/core/api/RuleProvider;", "Lcom/pinterest/ktlint/cli/reporter/core/api/KtlintCliError;", "ktLintRuleEngine", "Lcom/pinterest/ktlint/rule/engine/api/KtLintRuleEngine;", "code", "Lcom/pinterest/ktlint/rule/engine/api/Code;", "baselineLintErrors", "lint", "lintFiles", "lintErrorsPerFile", "", "reporter", "Lcom/pinterest/ktlint/cli/reporter/core/api/ReporterV2;", "lintStdin", "process", "readPatternsFromStdin", "delimiter", "report", "relativeRoute", "ktlintCliErrors", "ruleProviders$ktlint_cli", "run", "containsErrorThatCanBeAutocorrected", "parallel", "T", "Lkotlin/sequences/Sequence;", "Ljava/util/concurrent/Callable;", "cb", "Lkotlin/Function1;", "numberOfThreads", "replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty", "toKtlintCliError", "Ljava/lang/Exception;", "Lkotlin/Exception;", "underlyingLogger", "Lch/qos/logback/classic/Logger;", "ktlint-cli"})
@SourceDebugExtension(value={"SMAP\nKtlintCommandLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtlintCommandLine.kt\ncom/pinterest/ktlint/cli/internal/KtlintCommandLine\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,758:1\n271#2:759\n1#3:760\n1855#4,2:761\n1747#4,3:763\n857#4,2:766\n*S KotlinDebug\n*F\n+ 1 KtlintCommandLine.kt\ncom/pinterest/ktlint/cli/internal/KtlintCommandLine\n*L\n257#1:759\n456#1:761,2\n460#1:763,3\n652#1:766,2\n*E\n"})
public final class KtlintCommandLine {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec commandSpec;
    @CommandLine.Option(names={"--code-style"}, hidden=true, scope=CommandLine.ScopeType.INHERIT)
    @Nullable
    private CodeStyleValue codeStyle;
    @CommandLine.Option(names={"--color"}, description={"Make output colorful"})
    private boolean color;
    @CommandLine.Option(names={"--color-name"}, description={"Customize the output color"})
    @NotNull
    private String colorName = "DARK_GRAY";
    @CommandLine.Option(names={"--disabled_rules"}, hidden=true)
    @NotNull
    private String disabledRules = "";
    @CommandLine.Option(names={"--format", "-F"}, description={"Fix deviations from the code style when possible"})
    private boolean format;
    @CommandLine.Option(names={"--limit"}, description={"Maximum number of errors to show (default: show all)"})
    private int limit = -1;
    @CommandLine.Option(names={"--relative"}, description={"Print files relative to the working directory (e.g. dir/file.kt instead of /home/user/project/dir/file.kt)"})
    private boolean relative;
    @CommandLine.Option(names={"--reporter"}, description={"A reporter to use (built-in: plain (default), plain?group_by_file, plain-summary, json, sarif, checkstyle, html). To use a third-party reporter specify a path to a JAR file on the filesystem via ',artifact=' option. To override reporter output, use ',output=' option."})
    @NotNull
    private List<String> reporterConfigurations = new ArrayList();
    @CommandLine.Option(names={"--ruleset", "-R"}, description={"A path to a JAR file containing additional ruleset(s)"})
    @NotNull
    private List<String> rulesetJarPaths = new ArrayList();
    @CommandLine.Option(names={"--stdin"}, description={"Read file from stdin"})
    private boolean stdin;
    @CommandLine.Option(names={"--patterns-from-stdin"}, description={"Read additional patterns to check/format from stdin. Patterns are delimited by the given argument. (default is newline) If the argument is an empty string, the NUL byte is used."}, arity="0..1", fallbackValue="\n")
    @Nullable
    private String stdinDelimiter;
    @CommandLine.Option(names={"--editorconfig"}, description={"Path to the default '.editorconfig'. A property value from this file is used only when no '.editorconfig' file on the path to the source file specifies that property. Note: up until ktlint 0.46 the property value in this file used to override values found in '.editorconfig' files on the path to the source file."})
    @Nullable
    private String editorConfigPath;
    @CommandLine.Option(names={"--experimental"}, hidden=true)
    private boolean experimental;
    @CommandLine.Option(names={"--baseline"}, description={"Defines a baseline file to check against"})
    @NotNull
    private String baselinePath = "";
    @CommandLine.Parameters(hidden=true)
    @NotNull
    private List<String> patterns = CollectionsKt.emptyList();
    @CommandLine.Option(names={"--log-level", "-l"}, description={"Defines the minimum log level (trace, debug, info, warn, error) or none to suppress all logging"}, converter={LogLevelConverter.class})
    @NotNull
    private Level minLogLevel;
    @NotNull
    private final AtomicBoolean tripped;
    @NotNull
    private final AtomicInteger fileNumber;
    @NotNull
    private final AtomicInteger errorNumber;
    @NotNull
    private final AtomicBoolean adviseToUseFormat;
    private boolean debug;

    public KtlintCommandLine() {
        Level level = Level.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
        this.minLogLevel = level;
        this.tripped = new AtomicBoolean();
        this.fileNumber = new AtomicInteger();
        this.errorNumber = new AtomicInteger();
        this.adviseToUseFormat = new AtomicBoolean();
    }

    @Nullable
    public final CodeStyleValue getCodeStyle() {
        return this.codeStyle;
    }

    public final void setCodeStyle(@Nullable CodeStyleValue codeStyleValue) {
        this.codeStyle = codeStyleValue;
    }

    @Deprecated(message="Remove in Ktlint 1.2 (or later) as some users will skip multiple versions.")
    public static /* synthetic */ void getCodeStyle$annotations() {
    }

    public final boolean getColor() {
        return this.color;
    }

    public final void setColor(boolean bl) {
        this.color = bl;
    }

    @NotNull
    public final String getColorName() {
        return this.colorName;
    }

    public final void setColorName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.colorName = string;
    }

    @NotNull
    public final String getDisabledRules() {
        return this.disabledRules;
    }

    public final void setDisabledRules(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.disabledRules = string;
    }

    @Deprecated(message="Remove in Ktlint 1.2 (or later) as some users will skip multiple versions.")
    public static /* synthetic */ void getDisabledRules$annotations() {
    }

    private final int getLimit() {
        return this.limit < 0 ? Integer.MAX_VALUE : this.limit;
    }

    public final boolean getRelative() {
        return this.relative;
    }

    public final void setRelative(boolean bl) {
        this.relative = bl;
    }

    @NotNull
    public final List<String> getRulesetJarPaths() {
        return this.rulesetJarPaths;
    }

    public final void setRulesetJarPaths(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.rulesetJarPaths = list;
    }

    public final boolean getExperimental() {
        return this.experimental;
    }

    public final void setExperimental(boolean bl) {
        this.experimental = bl;
    }

    @Deprecated(message="Remove in Ktlint 1.2 (or later) as some users will skip multiple versions.")
    public static /* synthetic */ void getExperimental$annotations() {
    }

    public final boolean getDebug$ktlint_cli() {
        return Level.DEBUG.isGreaterOrEqual(this.minLogLevel);
    }

    /*
     * WARNING - void declaration
     */
    public final void run() {
        EditorConfigOverride editorConfigOverride2;
        void $this$applyIf$iv;
        if (this.experimental) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.error((Function0)run.1.INSTANCE);
            KtlintCommandLineKt.exitKtLintProcess(2);
            throw new KotlinNothingValueException();
        }
        if (!StringsKt.isBlank((CharSequence)this.disabledRules)) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.error((Function0)run.2.INSTANCE);
            KtlintCommandLineKt.exitKtLintProcess(3);
            throw new KotlinNothingValueException();
        }
        if (this.codeStyle != null) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.error((Function0)new Function0<Object>(this){
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    CodeStyleValue codeStyleValue = this.this$0.getCodeStyle();
                    return "Parameter '--code-style=" + (codeStyleValue != null ? codeStyleValue.name() : null) + "' is ignored. The code style should be defined as '.editorconfig' property 'ktlint_code_style='.";
                }
            });
            KtlintCommandLineKt.exitKtLintProcess(4);
            throw new KotlinNothingValueException();
        }
        EditorConfigOverride editorConfigOverride3 = EditorConfigOverride.Companion.getEMPTY_EDITOR_CONFIG_OVERRIDE();
        boolean if$iv = this.stdin;
        boolean $i$f$applyIf = false;
        if (if$iv) {
            void $this$run_u24lambda_u240 = $this$applyIf$iv;
            boolean bl = false;
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.debug((Function0)run.editorConfigOverride.1.1.INSTANCE);
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)RuleExecutionEditorConfigPropertyKt.createRuleExecutionEditorConfigProperty$default((RuleId)FilenameRuleKt.getFILENAME_RULE_ID(), null, (int)1, null), (Object)RuleExecution.disabled)};
            editorConfigOverride2 = EditorConfigOverride.Companion.plus((EditorConfigOverride)$this$run_u24lambda_u240, pairArray);
        } else {
            editorConfigOverride2 = $this$applyIf$iv;
        }
        void editorConfigOverride4 = editorConfigOverride2;
        this.assertStdinAndPatternsFromStdinOptionsMutuallyExclusive();
        this.patterns = this.replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty(this.patterns);
        long start = System.currentTimeMillis();
        Set<RuleProvider> ruleProviders = this.ruleProviders$ktlint_cli();
        KtLintRuleEngine ktLintRuleEngine = new KtLintRuleEngine(ruleProviders, this.editorConfigDefaults(ruleProviders), (EditorConfigOverride)editorConfigOverride4, true, null, 16, null);
        Baseline baseline = this.stdin || StringsKt.isBlank((CharSequence)this.baselinePath) ? new Baseline(null, Baseline.Status.DISABLED, null, 5, null) : BaselineKt.loadBaseline((String)this.baselinePath, (BaselineErrorHandling)BaselineErrorHandling.LOG);
        ReporterV2 aggregatedReporter = new ReporterAggregator(baseline, this.reporterConfigurations, this.color, this.colorName, this.stdin, this.format, this.relative).aggregatedReporter();
        aggregatedReporter.beforeAll();
        if (this.stdin) {
            this.lintStdin(ktLintRuleEngine, aggregatedReporter);
        } else {
            this.lintFiles(ktLintRuleEngine, baseline.getLintErrorsPerFile(), aggregatedReporter);
            if (this.adviseToUseFormat.get()) {
                if (this.format) {
                    KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                    if (kLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        kLogger = null;
                    }
                    kLogger.error((Function0)run.4.INSTANCE);
                } else {
                    KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                    if (kLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        kLogger = null;
                    }
                    kLogger.warn((Function0)run.5.INSTANCE);
                }
            }
        }
        aggregatedReporter.afterAll();
        KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
        if (kLogger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            kLogger = null;
        }
        kLogger.debug((Function0)new Function0<Object>(start, this){
            final /* synthetic */ long $start;
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.$start = $start;
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Object invoke() {
                return "Finished processing in " + (System.currentTimeMillis() - this.$start) + "ms / " + KtlintCommandLine.access$getFileNumber$p(this.this$0) + " file(s) scanned / " + KtlintCommandLine.access$getErrorNumber$p(this.this$0) + " error(s) found";
            }
        });
        if (this.fileNumber.get() == 0) {
            KLogger kLogger2 = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger2 = null;
            }
            kLogger2.warn((Function0)new Function0<Object>(this){
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "No files matched " + KtlintCommandLine.access$getPatterns$p(this.this$0);
                }
            });
        }
        if (this.tripped.get()) {
            KtlintCommandLineKt.exitKtLintProcess(1);
            throw new KotlinNothingValueException();
        }
        KtlintCommandLineKt.exitKtLintProcess(0);
        throw new KotlinNothingValueException();
    }

    private final EditorConfigDefaults editorConfigDefaults(Set<RuleProvider> ruleProviders) {
        Path path2;
        String string;
        String string2 = this.editorConfigPath;
        if (string2 != null && (string = FileUtilsKt.expandTildeToFullPath(string2)) != null) {
            String path3 = string;
            boolean bl = false;
            path2 = Paths.get(path3, new String[0]);
        } else {
            path2 = null;
        }
        Path fullyExpandedEditorConfigPath = path2;
        return EditorConfigDefaults.Companion.load(fullyExpandedEditorConfigPath, RuleProviderKt.propertyTypes((Collection)ruleProviders));
    }

    private final List<String> replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty(List<String> $this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty) {
        List list;
        String localStdinDelimiter = this.stdinDelimiter;
        if (localStdinDelimiter != null) {
            CharSequence charSequence;
            KtlintCommandLine ktlintCommandLine = this;
            CharSequence charSequence2 = localStdinDelimiter;
            if (charSequence2.length() == 0) {
                KtlintCommandLine ktlintCommandLine2 = ktlintCommandLine;
                boolean bl = false;
                charSequence = "\u0000";
                ktlintCommandLine = ktlintCommandLine2;
            } else {
                charSequence = charSequence2;
            }
            Set<String> stdinPatterns = ktlintCommandLine.readPatternsFromStdin((String)charSequence);
            if (!((Collection)$this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty).isEmpty() && !((Collection)stdinPatterns).isEmpty()) {
                KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                if (kLogger == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    kLogger = null;
                }
                kLogger.warn((Function0)new Function0<Object>((List<String>)$this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty, stdinPatterns){
                    final /* synthetic */ List<String> $this_replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty;
                    final /* synthetic */ Set<String> $stdinPatterns;
                    {
                        this.$this_replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty = $receiver;
                        this.$stdinPatterns = $stdinPatterns;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return "Patterns specified at command line (" + this.$this_replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty + ") and patterns from 'stdin' due to flag '--patterns-from-stdin' (" + this.$stdinPatterns + ") are merged";
                    }
                });
            }
            list = CollectionsKt.plus((Collection)$this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty, (Iterable)stdinPatterns);
        } else if ($this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty.isEmpty()) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.info((Function0)replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty.2.INSTANCE);
            list = FileUtilsKt.getDEFAULT_PATTERNS();
        } else {
            list = $this$replaceWithPatternsFromStdinOrDefaultPatternsWhenEmpty;
        }
        return list;
    }

    @NotNull
    public final Set<RuleProvider> ruleProviders$ktlint_cli() {
        return LoadRuleProvidersKt.loadRuleProviders(KtlintCommandLineKt.toFilesURIList(this.rulesetJarPaths));
    }

    public final void configureLogger$ktlint_cli() {
        KtlintCommandLineKt.access$setLogger$p(KtLintKLoggerInitializerKt.initKtLintKLogger((KLogger)KtLintKLoggerInitializerKt.setDefaultLoggerModifier((KLogger)KotlinLogging.INSTANCE.logger((Function0)configureLogger.1.INSTANCE), (Function1)((Function1)new Function1<KLogger, Unit>(this){
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull KLogger logger) {
                Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
                KtlintCommandLine.access$setLevel(this.this$0, logger, KtlintCommandLine.access$getMinLogLevel$p(this.this$0));
            }
        }))));
    }

    private final Level getLevel(KLogger $this$level) {
        Logger logger = this.underlyingLogger($this$level);
        return logger != null ? logger.getLevel() : null;
    }

    private final void setLevel(KLogger $this$level, Level value) {
        Logger logger = this.underlyingLogger($this$level);
        if (logger != null) {
            logger.setLevel(value);
        }
    }

    private final Logger underlyingLogger(KLogger $this$underlyingLogger) {
        DelegatingKLogger delegatingKLogger = $this$underlyingLogger instanceof DelegatingKLogger ? (DelegatingKLogger)$this$underlyingLogger : null;
        return delegatingKLogger != null ? (Logger)delegatingKLogger.getUnderlyingLogger() : null;
    }

    private final void assertStdinAndPatternsFromStdinOptionsMutuallyExclusive() {
        if (this.stdin && this.stdinDelimiter != null) {
            CommandLine.Model.CommandSpec commandSpec = this.commandSpec;
            if (commandSpec == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"commandSpec");
                commandSpec = null;
            }
            throw new CommandLine.ParameterException(commandSpec.commandLine(), "Options --stdin and --patterns-from-stdin are mutually exclusive");
        }
    }

    private final void lintFiles(KtLintRuleEngine ktLintRuleEngine, Map<String, ? extends List<KtlintCliError>> lintErrorsPerFile, ReporterV2 reporter) {
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault(...)");
        KtlintCommandLine.parallel$default(this, SequencesKt.map((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.map((Sequence)FileUtilsKt.fileSequence$default(fileSystem, this.patterns, null, 2, null), (Function1)lintFiles.1.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(this){
            final /* synthetic */ KtlintCommandLine this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(File it) {
                return KtlintCommandLine.access$getErrorNumber$p(this.this$0).get() < KtlintCommandLine.access$getLimit(this.this$0);
            }
        })), (Function1)((Function1)new Function1<File, Callable<Pair<? extends File, ? extends List<? extends KtlintCliError>>>>(this, ktLintRuleEngine, lintErrorsPerFile){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ KtLintRuleEngine $ktLintRuleEngine;
            final /* synthetic */ Map<String, List<KtlintCliError>> $lintErrorsPerFile;
            {
                this.this$0 = $receiver;
                this.$ktLintRuleEngine = $ktLintRuleEngine;
                this.$lintErrorsPerFile = $lintErrorsPerFile;
                super(1);
            }

            @NotNull
            public final Callable<Pair<File, List<KtlintCliError>>> invoke(File file) {
                return () -> lintFiles.3.invoke$lambda$0(file, this.this$0, this.$ktLintRuleEngine, this.$lintErrorsPerFile);
            }

            private static final Pair invoke$lambda$0(File $file, KtlintCommandLine this$0, KtLintRuleEngine $ktLintRuleEngine, Map $lintErrorsPerFile) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$ktLintRuleEngine, (String)"$ktLintRuleEngine");
                Intrinsics.checkNotNullParameter((Object)$lintErrorsPerFile, (String)"$lintErrorsPerFile");
                Intrinsics.checkNotNull((Object)$file);
                return TuplesKt.to((Object)$file, (Object)KtlintCommandLine.access$process(this$0, $ktLintRuleEngine, Code.Companion.fromFile($file), $lintErrorsPerFile.getOrDefault(FileUtilsKt.location($file, true), CollectionsKt.emptyList())));
            }
        })), (Function1)new Function1<Pair<? extends File, ? extends List<? extends KtlintCliError>>, Unit>(this, reporter){
            final /* synthetic */ KtlintCommandLine this$0;
            final /* synthetic */ ReporterV2 $reporter;
            {
                this.this$0 = $receiver;
                this.$reporter = $reporter;
                super(1);
            }

            public final void invoke(Pair<? extends File, ? extends List<KtlintCliError>> pair) {
                File file = (File)pair.component1();
                List errList = (List)pair.component2();
                Intrinsics.checkNotNull((Object)file);
                KtlintCommandLine.access$report(this.this$0, FileUtilsKt.location(file, this.this$0.getRelative()), errList, this.$reporter);
            }
        }, 0, 2, null);
    }

    private final void lintStdin(KtLintRuleEngine ktLintRuleEngine, ReporterV2 reporter) {
        this.report("<stdin>", this.process(ktLintRuleEngine, Code.Companion.fromStdin(), CollectionsKt.emptyList()), reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void report(String relativeRoute, List<KtlintCliError> ktlintCliErrors, ReporterV2 reporter) {
        void $this$forEach$iv;
        this.fileNumber.incrementAndGet();
        int errListLimit = Math.min(ktlintCliErrors.size(), Math.max(this.getLimit() - this.errorNumber.get(), 0));
        this.errorNumber.addAndGet(errListLimit);
        if (!this.adviseToUseFormat.get() && this.containsErrorThatCanBeAutocorrected(ktlintCliErrors)) {
            this.adviseToUseFormat.set(true);
        }
        reporter.before(relativeRoute);
        Iterable iterable = CollectionsKt.take((Iterable)ktlintCliErrors, (int)errListLimit);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtlintCliError it = (KtlintCliError)element$iv;
            boolean bl = false;
            reporter.onLintError(relativeRoute, it);
        }
        reporter.after(relativeRoute);
    }

    private final boolean containsErrorThatCanBeAutocorrected(List<KtlintCliError> $this$containsErrorThatCanBeAutocorrected) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = $this$containsErrorThatCanBeAutocorrected;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtlintCliError it = (KtlintCliError)element$iv;
                    boolean bl2 = false;
                    if (!(it.getStatus() == KtlintCliError.Status.LINT_CAN_BE_AUTOCORRECTED)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final List<KtlintCliError> process(KtLintRuleEngine ktLintRuleEngine, Code code, List<KtlintCliError> baselineLintErrors) {
        if (code.getFileName() != null) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.trace((Function0)new Function0<Object>(code, this){
                final /* synthetic */ Code $code;
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.$code = $code;
                    this.this$0 = $receiver;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Checking ");
                    String string = this.$code.getFileName();
                    Intrinsics.checkNotNull((Object)string);
                    return stringBuilder.append(FileUtilsKt.location(new File(string), this.this$0.getRelative())).toString();
                }
            });
        }
        return this.format ? this.format(ktLintRuleEngine, code, baselineLintErrors) : this.lint(ktLintRuleEngine, code, baselineLintErrors);
    }

    private final List<KtlintCliError> format(KtLintRuleEngine ktLintRuleEngine, Code code, List<KtlintCliError> baselineLintErrors) {
        List ktlintCliErrors = new ArrayList();
        try {
            File file;
            Path path2;
            String string;
            String formattedFileContent = string = ktLintRuleEngine.format(code, (Function2)new Function2<LintError, Boolean, Unit>(baselineLintErrors, (List<KtlintCliError>)ktlintCliErrors, this){
                final /* synthetic */ List<KtlintCliError> $baselineLintErrors;
                final /* synthetic */ List<KtlintCliError> $ktlintCliErrors;
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.$baselineLintErrors = $baselineLintErrors;
                    this.$ktlintCliErrors = $ktlintCliErrors;
                    this.this$0 = $receiver;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull LintError lintError, boolean corrected) {
                    String string;
                    void $this$applyIf$iv;
                    Intrinsics.checkNotNullParameter((Object)lintError, (String)"lintError");
                    int n = lintError.getLine();
                    int n2 = lintError.getCol();
                    String string2 = lintError.getRuleId().getValue();
                    String string3 = lintError.getDetail();
                    boolean $i$f$applyIf = false;
                    if (corrected) {
                        void $this$invoke_u24lambda_u240;
                        void var6_5 = $this$applyIf$iv;
                        String string4 = string2;
                        int n3 = n2;
                        int n4 = n;
                        boolean bl = false;
                        String string5 = (String)$this$invoke_u24lambda_u240 + " (cannot be auto-corrected)";
                        n = n4;
                        n2 = n3;
                        string2 = string4;
                        string = string5;
                    } else {
                        string = $this$applyIf$iv;
                    }
                    KtlintCliError.Status status = corrected ? KtlintCliError.Status.FORMAT_IS_AUTOCORRECTED : KtlintCliError.Status.LINT_CAN_NOT_BE_AUTOCORRECTED;
                    void var13_12 = string;
                    String string6 = string2;
                    int n5 = n2;
                    int n6 = n;
                    KtlintCliError ktlintCliError = new KtlintCliError(n6, n5, string6, (String)var13_12, status);
                    if (BaselineKt.doesNotContain(this.$baselineLintErrors, (KtlintCliError)ktlintCliError)) {
                        this.$ktlintCliErrors.add(ktlintCliError);
                        if (!corrected) {
                            KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                        }
                    }
                }
            });
            boolean bl = false;
            if (code.isStdIn()) {
                System.out.print((Object)formattedFileContent);
            } else if (!Intrinsics.areEqual((Object)code.getContent(), (Object)formattedFileContent) && (path2 = code.getFilePath()) != null && (file = path2.toFile()) != null) {
                Charset charset = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
                FilesKt.writeText((File)file, (String)formattedFileContent, (Charset)charset);
            }
        }
        catch (Exception e) {
            if (code.isStdIn() && e instanceof KtLintParseException) {
                if (code.getScript()) {
                    KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                    if (kLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        kLogger = null;
                    }
                    kLogger.error((Function0)new Function0<Object>(this, e, code){
                        final /* synthetic */ KtlintCommandLine this$0;
                        final /* synthetic */ Exception $e;
                        final /* synthetic */ Code $code;
                        {
                            this.this$0 = $receiver;
                            this.$e = $e;
                            this.$code = $code;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return StringsKt.trimIndent((String)("\n                        Can not parse input from <stdin> as Kotlin, due to error below:\n                            " + KtlintCommandLine.access$toKtlintCliError(this.this$0, this.$e, this.$code).getDetail() + "\n                        "));
                        }
                    });
                    ktlintCliErrors.add(this.toKtlintCliError(e, code));
                }
                KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                if (kLogger == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    kLogger = null;
                }
                kLogger.warn((Function0)new Function0<Object>(this, e, code){
                    final /* synthetic */ KtlintCommandLine this$0;
                    final /* synthetic */ Exception $e;
                    final /* synthetic */ Code $code;
                    {
                        this.this$0 = $receiver;
                        this.$e = $e;
                        this.$code = $code;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return StringsKt.trimIndent((String)("\n                        Can not parse input from <stdin> as Kotlin, due to error below:\n                            " + KtlintCommandLine.access$toKtlintCliError(this.this$0, this.$e, this.$code).getDetail() + "\n                        Now, trying to read the input as Kotlin Script.\n                        "));
                    }
                });
                return this.format(ktLintRuleEngine, Code.Companion.fromSnippet(code.getContent(), true), baselineLintErrors);
            }
            ktlintCliErrors.add(this.toKtlintCliError(e, code));
            this.tripped.set(true);
            code.getContent();
        }
        return CollectionsKt.toList((Iterable)ktlintCliErrors);
    }

    private final List<KtlintCliError> lint(KtLintRuleEngine ktLintRuleEngine, Code code, List<KtlintCliError> baselineLintErrors) {
        List ktlintCliErrors = new ArrayList();
        try {
            ktLintRuleEngine.lint(code, (Function1)new Function1<LintError, Unit>(baselineLintErrors, (List<KtlintCliError>)ktlintCliErrors, this){
                final /* synthetic */ List<KtlintCliError> $baselineLintErrors;
                final /* synthetic */ List<KtlintCliError> $ktlintCliErrors;
                final /* synthetic */ KtlintCommandLine this$0;
                {
                    this.$baselineLintErrors = $baselineLintErrors;
                    this.$ktlintCliErrors = $ktlintCliErrors;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull LintError lintError) {
                    Intrinsics.checkNotNullParameter((Object)lintError, (String)"lintError");
                    KtlintCliError ktlintCliError = new KtlintCliError(lintError.getLine(), lintError.getCol(), lintError.getRuleId().getValue(), lintError.getDetail(), lintError.getCanBeAutoCorrected() ? KtlintCliError.Status.LINT_CAN_BE_AUTOCORRECTED : KtlintCliError.Status.LINT_CAN_NOT_BE_AUTOCORRECTED);
                    if (BaselineKt.doesNotContain(this.$baselineLintErrors, (KtlintCliError)ktlintCliError)) {
                        this.$ktlintCliErrors.add(ktlintCliError);
                        KtlintCommandLine.access$getTripped$p(this.this$0).set(true);
                    }
                }
            });
        }
        catch (Exception e) {
            if (code.isStdIn() && e instanceof KtLintParseException) {
                if (code.getScript()) {
                    KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                    if (kLogger == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                        kLogger = null;
                    }
                    kLogger.error((Function0)new Function0<Object>(this, e, code){
                        final /* synthetic */ KtlintCommandLine this$0;
                        final /* synthetic */ Exception $e;
                        final /* synthetic */ Code $code;
                        {
                            this.this$0 = $receiver;
                            this.$e = $e;
                            this.$code = $code;
                            super(0);
                        }

                        @Nullable
                        public final Object invoke() {
                            return StringsKt.trimIndent((String)("\n                        Can not parse input from <stdin> as Kotlin, due to error below:\n                            " + KtlintCommandLine.access$toKtlintCliError(this.this$0, this.$e, this.$code).getDetail() + "\n                        "));
                        }
                    });
                    ktlintCliErrors.add(this.toKtlintCliError(e, code));
                }
                KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
                if (kLogger == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                    kLogger = null;
                }
                kLogger.warn((Function0)new Function0<Object>(this, e, code){
                    final /* synthetic */ KtlintCommandLine this$0;
                    final /* synthetic */ Exception $e;
                    final /* synthetic */ Code $code;
                    {
                        this.this$0 = $receiver;
                        this.$e = $e;
                        this.$code = $code;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return StringsKt.trimIndent((String)("\n                        Can not parse input from <stdin> as Kotlin, due to error below:\n                            " + KtlintCommandLine.access$toKtlintCliError(this.this$0, this.$e, this.$code).getDetail() + "\n                        Now, trying to read the input as Kotlin Script.\n                        "));
                    }
                });
                return this.lint(ktLintRuleEngine, Code.Companion.fromSnippet(code.getContent(), true), baselineLintErrors);
            }
            ktlintCliErrors.add(this.toKtlintCliError(e, code));
            this.tripped.set(true);
        }
        return CollectionsKt.toList((Iterable)ktlintCliErrors);
    }

    private final KtlintCliError toKtlintCliError(Exception $this$toKtlintCliError, Code code) {
        KtlintCliError ktlintCliError;
        Exception e = $this$toKtlintCliError;
        boolean bl = false;
        Exception exception = e;
        if (exception instanceof KtLintParseException) {
            String string;
            int n = ((KtLintParseException)e).getLine();
            int n2 = ((KtLintParseException)e).getCol();
            StringBuilder stringBuilder = new StringBuilder().append("Not a valid Kotlin file (");
            String string2 = e.getMessage();
            if (string2 != null) {
                String string3 = string2;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string4 = string3.toLowerCase(locale);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            } else {
                string = null;
            }
            ktlintCliError = new KtlintCliError(n, n2, "", stringBuilder.append(string).append(')').toString(), KtlintCliError.Status.KOTLIN_PARSE_EXCEPTION);
        } else if (exception instanceof KtLintRuleException) {
            KLogger kLogger = KtlintCommandLineKt.access$getLogger$p();
            if (kLogger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
                kLogger = null;
            }
            kLogger.debug((Throwable)e, (Function0)new Function0<Object>(e, code){
                final /* synthetic */ Exception $e;
                final /* synthetic */ Code $code;
                {
                    this.$e = $e;
                    this.$code = $code;
                    super(0);
                }

                @Nullable
                public final Object invoke() {
                    return "Internal Error (" + ((KtLintRuleException)this.$e).getRuleId() + ") in " + this.$code.fileNameOrStdin() + " at position '" + ((KtLintRuleException)this.$e).getLine() + ':' + ((KtLintRuleException)this.$e).getCol();
                }
            });
            ktlintCliError = new KtlintCliError(((KtLintRuleException)e).getLine(), ((KtLintRuleException)e).getCol(), "", "Internal Error (rule '" + ((KtLintRuleException)e).getRuleId() + "') in " + code.fileNameOrStdin() + " at position '" + ((KtLintRuleException)e).getLine() + ':' + ((KtLintRuleException)e).getCol() + ". Please create a ticket at https://github.com/pinterest/ktlint/issues and provide the source code that triggered an error.\n" + ExceptionsKt.stackTraceToString((Throwable)e), KtlintCliError.Status.KTLINT_RULE_ENGINE_EXCEPTION);
        } else {
            throw e;
        }
        return ktlintCliError;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> readPatternsFromStdin(String delimiter) {
        void $this$filterTo$iv;
        if (!(((CharSequence)delimiter).length() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        InputStream inputStream = System.in;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"in");
        Object[] objectArray = ByteStreamsKt.readBytes((InputStream)inputStream);
        String string = new String((byte[])objectArray, Charsets.UTF_8);
        objectArray = new String[1];
        objectArray[0] = (byte)delimiter;
        List patterns = StringsKt.split$default((CharSequence)string, (String[])objectArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        Iterable iterable = patterns;
        Collection destination$iv = new LinkedHashSet(patterns.size());
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            String p0 = (String)element$iv;
            boolean bl2 = false;
            if (!(((CharSequence)p0).length() > 0)) continue;
            destination$iv.add(element$iv);
        }
        return (LinkedHashSet)destination$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T> void parallel(Sequence<? extends Callable<T>> $this$parallel, Function1<? super T, Unit> cb, int numberOfThreads) {
        Future pill2 = new Future<T>(){

            public boolean isDone() {
                throw new UnsupportedOperationException();
            }

            public T get(long timeout, @NotNull TimeUnit unit) {
                Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
                throw new UnsupportedOperationException();
            }

            public T get() {
                throw new UnsupportedOperationException();
            }

            public boolean cancel(boolean mayInterruptIfRunning) {
                throw new UnsupportedOperationException();
            }

            public boolean isCancelled() {
                throw new UnsupportedOperationException();
            }
        };
        ArrayBlockingQueue q = new ArrayBlockingQueue(numberOfThreads);
        Thread producer2 = ThreadsKt.thread$default((boolean)true, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>($this$parallel, q, pill2){
            final /* synthetic */ Sequence<Callable<T>> $this_parallel;
            final /* synthetic */ ArrayBlockingQueue<Future<T>> $q;
            final /* synthetic */ parallel.pill.1<T> $pill;
            {
                this.$this_parallel = $receiver;
                this.$q = $q;
                this.$pill = $pill;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                ExecutorService executorService = Executors.newCachedThreadPool();
                try {
                    for (Callable task : this.$this_parallel) {
                        this.$q.put(executorService.submit(task));
                    }
                    this.$q.put(this.$pill);
                }
                catch (InterruptedException interruptedException) {
                }
                finally {
                    executorService.shutdown();
                }
            }
        }), (int)30, null);
        try {
            Future result;
            while (!Intrinsics.areEqual(result = q.take(), (Object)pill2)) {
                cb.invoke(result.get());
            }
        }
        finally {
            producer2.interrupt();
            producer2.join();
        }
    }

    static /* synthetic */ void parallel$default(KtlintCommandLine ktlintCommandLine, Sequence sequence, Function1 function1, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Runtime.getRuntime().availableProcessors();
        }
        ktlintCommandLine.parallel(sequence, function1, n);
    }

    public static final /* synthetic */ AtomicInteger access$getFileNumber$p(KtlintCommandLine $this) {
        return $this.fileNumber;
    }

    public static final /* synthetic */ AtomicInteger access$getErrorNumber$p(KtlintCommandLine $this) {
        return $this.errorNumber;
    }

    public static final /* synthetic */ List access$getPatterns$p(KtlintCommandLine $this) {
        return $this.patterns;
    }

    public static final /* synthetic */ void access$setLevel(KtlintCommandLine $this, KLogger $receiver, Level value) {
        $this.setLevel($receiver, value);
    }

    public static final /* synthetic */ Level access$getMinLogLevel$p(KtlintCommandLine $this) {
        return $this.minLogLevel;
    }

    public static final /* synthetic */ int access$getLimit(KtlintCommandLine $this) {
        return $this.getLimit();
    }

    public static final /* synthetic */ List access$process(KtlintCommandLine $this, KtLintRuleEngine ktLintRuleEngine, Code code, List baselineLintErrors) {
        return $this.process(ktLintRuleEngine, code, baselineLintErrors);
    }

    public static final /* synthetic */ void access$report(KtlintCommandLine $this, String relativeRoute, List ktlintCliErrors, ReporterV2 reporter) {
        $this.report(relativeRoute, ktlintCliErrors, reporter);
    }

    public static final /* synthetic */ AtomicBoolean access$getTripped$p(KtlintCommandLine $this) {
        return $this.tripped;
    }

    public static final /* synthetic */ KtlintCliError access$toKtlintCliError(KtlintCommandLine $this, Exception $receiver, Code code) {
        return $this.toKtlintCliError($receiver, code);
    }
}

