/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.androidyoutubeplayer.ui;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.pierfrancescosoffritti.androidyoutubeplayer.R;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.PlayerConstants;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.YouTubePlayerView;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerFullScreenListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.ui.PlayerUIController;
import com.pierfrancescosoffritti.androidyoutubeplayer.ui.menu.YouTubePlayerMenu;
import com.pierfrancescosoffritti.androidyoutubeplayer.ui.menu.defaultMenu.DefaultYouTubePlayerMenu;
import com.pierfrancescosoffritti.androidyoutubeplayer.utils.Utils;

public class DefaultPlayerUIController
implements View.OnClickListener,
SeekBar.OnSeekBarChangeListener,
YouTubePlayerFullScreenListener,
YouTubePlayerListener,
PlayerUIController {
    @NonNull
    private final YouTubePlayerView a;
    @NonNull
    private final YouTubePlayer b;
    @NonNull
    private YouTubePlayerMenu c;
    private View d;
    private View e;
    private LinearLayout f;
    private TextView g;
    private TextView h;
    private TextView i;
    private TextView j;
    private ProgressBar k;
    private ImageView l;
    private ImageView m;
    private ImageView n;
    private ImageView o;
    private ImageView p;
    private ImageView q;
    private SeekBar r;
    @Nullable
    private View.OnClickListener s;
    @Nullable
    private View.OnClickListener t;
    private boolean u = false;
    private boolean v = true;
    private boolean w = false;
    private boolean x = true;
    private boolean y = true;
    private boolean z = true;
    private final Handler A = new Handler(Looper.getMainLooper());
    private final Runnable B = new Runnable(){

        @Override
        public void run() {
            DefaultPlayerUIController.this.a(0.0f);
        }
    };
    private boolean C = false;
    private int D = -1;

    public DefaultPlayerUIController(@NonNull YouTubePlayerView youTubePlayerView, @NonNull YouTubePlayer youTubePlayer) {
        this.a = youTubePlayerView;
        this.b = youTubePlayer;
        View view = View.inflate((Context)youTubePlayerView.getContext(), (int)R.layout.default_player_ui, (ViewGroup)youTubePlayerView);
        this.a(view);
        this.c = new DefaultYouTubePlayerMenu(youTubePlayerView.getContext());
    }

    private void a(View view) {
        this.d = view.findViewById(R.id.panel);
        this.e = view.findViewById(R.id.controls_root);
        this.f = (LinearLayout)view.findViewById(R.id.extra_views_container);
        this.g = (TextView)view.findViewById(R.id.video_title);
        this.h = (TextView)view.findViewById(R.id.video_current_time);
        this.i = (TextView)view.findViewById(R.id.video_duration);
        this.j = (TextView)view.findViewById(R.id.live_video_indicator);
        this.k = (ProgressBar)view.findViewById(R.id.progress);
        this.l = (ImageView)view.findViewById(R.id.menu_button);
        this.m = (ImageView)view.findViewById(R.id.play_pause_button);
        this.n = (ImageView)view.findViewById(R.id.youtube_button);
        this.o = (ImageView)view.findViewById(R.id.fullscreen_button);
        this.p = (ImageView)view.findViewById(R.id.custom_action_left_button);
        this.q = (ImageView)view.findViewById(R.id.custom_action_right_button);
        this.r = (SeekBar)view.findViewById(R.id.seek_bar);
        this.r.setOnSeekBarChangeListener((SeekBar.OnSeekBarChangeListener)this);
        this.d.setOnClickListener((View.OnClickListener)this);
        this.m.setOnClickListener((View.OnClickListener)this);
        this.l.setOnClickListener((View.OnClickListener)this);
        this.o.setOnClickListener((View.OnClickListener)this);
    }

    @Override
    public void showVideoTitle(boolean bl) {
        int n = bl ? 0 : 8;
        this.g.setVisibility(n);
    }

    @Override
    public void setVideoTitle(@NonNull String string) {
        this.g.setText((CharSequence)string);
    }

    @Override
    public void showUI(boolean bl) {
        int n = bl ? 0 : 4;
        this.e.setVisibility(n);
        this.x = bl;
    }

    @Override
    public void showPlayPauseButton(boolean bl) {
        int n = bl ? 0 : 8;
        this.m.setVisibility(n);
        this.y = bl;
    }

    @Override
    public void enableLiveVideoUI(boolean bl) {
        if (bl) {
            this.i.setVisibility(4);
            this.r.setVisibility(4);
            this.h.setVisibility(4);
            this.j.setVisibility(0);
        } else {
            this.i.setVisibility(0);
            this.r.setVisibility(0);
            this.h.setVisibility(0);
            this.j.setVisibility(8);
        }
    }

    @Override
    public void setCustomAction1(@NonNull Drawable drawable2, View.OnClickListener onClickListener) {
        this.p.setImageDrawable(drawable2);
        this.p.setOnClickListener(onClickListener);
        this.showCustomAction1(onClickListener != null);
    }

    @Override
    public void setCustomAction2(@NonNull Drawable drawable2, View.OnClickListener onClickListener) {
        this.q.setImageDrawable(drawable2);
        this.q.setOnClickListener(onClickListener);
        this.showCustomAction2(onClickListener != null);
    }

    @Override
    public void showCustomAction1(boolean bl) {
        int n = bl ? 0 : 8;
        this.p.setVisibility(n);
    }

    @Override
    public void showCustomAction2(boolean bl) {
        int n = bl ? 0 : 8;
        this.q.setVisibility(n);
    }

    @Override
    public void showMenuButton(boolean bl) {
        int n = bl ? 0 : 8;
        this.l.setVisibility(n);
    }

    @Override
    public void setMenuButtonClickListener(@NonNull View.OnClickListener onClickListener) {
        this.t = onClickListener;
    }

    @Override
    public void showCurrentTime(boolean bl) {
        int n = bl ? 0 : 8;
        this.h.setVisibility(n);
    }

    @Override
    public void showDuration(boolean bl) {
        int n = bl ? 0 : 8;
        this.i.setVisibility(n);
    }

    @Override
    public void showSeekBar(boolean bl) {
        int n = bl ? 0 : 4;
        this.r.setVisibility(n);
    }

    @Override
    public void showBufferingProgress(boolean bl) {
        this.z = bl;
    }

    @Override
    public void showYouTubeButton(boolean bl) {
        int n = bl ? 0 : 8;
        this.n.setVisibility(n);
    }

    @Override
    public void addView(@NonNull View view) {
        this.f.addView(view, 0);
    }

    @Override
    public void removeView(@NonNull View view) {
        this.f.removeView(view);
    }

    @Override
    @NonNull
    public YouTubePlayerMenu getMenu() {
        return this.c;
    }

    @Override
    public void setMenu(@NonNull YouTubePlayerMenu youTubePlayerMenu) {
        this.c = youTubePlayerMenu;
    }

    @Override
    public void showFullscreenButton(boolean bl) {
        int n = bl ? 0 : 8;
        this.o.setVisibility(n);
    }

    @Override
    public void setFullScreenButtonClickListener(@NonNull View.OnClickListener onClickListener) {
        this.s = onClickListener;
    }

    public void onClick(View view) {
        if (view == this.d) {
            this.d();
        } else if (view == this.m) {
            this.c();
        } else if (view == this.o) {
            this.b();
        } else if (view == this.l) {
            this.a();
        }
    }

    private void a() {
        if (this.t == null) {
            this.c.show((View)this.l);
        } else {
            this.t.onClick((View)this.l);
        }
    }

    private void b() {
        if (this.s == null) {
            this.a.toggleFullScreen();
        } else {
            this.s.onClick((View)this.o);
        }
    }

    private void c() {
        if (this.u) {
            this.b.pause();
        } else {
            this.b.play();
        }
    }

    private void a(boolean bl) {
        int n = bl ? R.drawable.ic_pause_36dp : R.drawable.ic_play_36dp;
        this.m.setImageResource(n);
    }

    private void d() {
        float f = this.v ? 0.0f : 1.0f;
        this.a(f);
    }

    private void a(final float f) {
        if (!this.w || !this.x) {
            return;
        }
        boolean bl = this.v = f != 0.0f;
        if (f == 1.0f && this.u) {
            this.e();
        } else {
            this.A.removeCallbacks(this.B);
        }
        this.e.animate().alpha(f).setDuration(300L).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animator) {
                if (f == 1.0f) {
                    DefaultPlayerUIController.this.e.setVisibility(0);
                }
            }

            public void onAnimationEnd(Animator animator) {
                if (f == 0.0f) {
                    DefaultPlayerUIController.this.e.setVisibility(8);
                }
            }

            public void onAnimationCancel(Animator animator) {
            }

            public void onAnimationRepeat(Animator animator) {
            }
        }).start();
    }

    private void e() {
        this.A.postDelayed(this.B, 3000L);
    }

    @Override
    public void onYouTubePlayerEnterFullScreen() {
        this.o.setImageResource(R.drawable.ic_fullscreen_exit_24dp);
    }

    @Override
    public void onYouTubePlayerExitFullScreen() {
        this.o.setImageResource(R.drawable.ic_fullscreen_24dp);
    }

    @Override
    public void onStateChange(@NonNull PlayerConstants.PlayerState playerState) {
        this.D = -1;
        this.a(playerState);
        if (playerState == PlayerConstants.PlayerState.PLAYING || playerState == PlayerConstants.PlayerState.PAUSED || playerState == PlayerConstants.PlayerState.VIDEO_CUED) {
            this.d.setBackgroundColor(ContextCompat.getColor((Context)this.a.getContext(), (int)17170445));
            this.k.setVisibility(8);
            if (this.y) {
                this.m.setVisibility(0);
            }
            this.w = true;
            boolean bl = playerState == PlayerConstants.PlayerState.PLAYING;
            this.a(bl);
            if (bl) {
                this.e();
            } else {
                this.A.removeCallbacks(this.B);
            }
        } else {
            this.a(false);
            this.a(1.0f);
            if (playerState == PlayerConstants.PlayerState.BUFFERING) {
                this.d.setBackgroundColor(ContextCompat.getColor((Context)this.a.getContext(), (int)17170445));
                if (this.y) {
                    this.m.setVisibility(4);
                }
                this.p.setVisibility(8);
                this.q.setVisibility(8);
                this.w = false;
            }
            if (playerState == PlayerConstants.PlayerState.UNSTARTED) {
                this.w = false;
                this.k.setVisibility(8);
                if (this.y) {
                    this.m.setVisibility(0);
                }
            }
        }
    }

    private void a(PlayerConstants.PlayerState playerState) {
        switch (playerState) {
            case ENDED: {
                this.u = false;
                break;
            }
            case PAUSED: {
                this.u = false;
                break;
            }
            case PLAYING: {
                this.u = true;
                break;
            }
            case UNSTARTED: {
                this.f();
                break;
            }
        }
        this.a(!this.u);
    }

    @Override
    public void onCurrentSecond(float f) {
        if (this.C) {
            return;
        }
        if (this.D > 0 && !Utils.formatTime(f).equals(Utils.formatTime(this.D))) {
            return;
        }
        this.D = -1;
        this.r.setProgress((int)f);
    }

    @Override
    public void onVideoDuration(float f) {
        this.i.setText((CharSequence)Utils.formatTime(f));
        this.r.setMax((int)f);
    }

    @Override
    public void onVideoLoadedFraction(float f) {
        if (this.z) {
            this.r.setSecondaryProgress((int)(f * (float)this.r.getMax()));
        } else {
            this.r.setSecondaryProgress(0);
        }
    }

    @Override
    public void onVideoId(final @NonNull String string) {
        this.n.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)("http://www.youtube.com/watch?v=" + string + "#t=" + DefaultPlayerUIController.this.r.getProgress())));
                DefaultPlayerUIController.this.e.getContext().startActivity(intent);
            }
        });
    }

    @Override
    public void onReady() {
    }

    @Override
    public void onPlaybackQualityChange(@NonNull PlayerConstants.PlaybackQuality playbackQuality) {
    }

    @Override
    public void onPlaybackRateChange(@NonNull PlayerConstants.PlaybackRate playbackRate) {
    }

    @Override
    public void onError(@NonNull PlayerConstants.PlayerError playerError) {
    }

    @Override
    public void onApiChange() {
    }

    public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
        this.h.setText((CharSequence)Utils.formatTime(n));
    }

    public void onStartTrackingTouch(SeekBar seekBar) {
        this.C = true;
    }

    public void onStopTrackingTouch(SeekBar seekBar) {
        if (this.u) {
            this.D = seekBar.getProgress();
        }
        this.b.seekTo(seekBar.getProgress());
        this.C = false;
    }

    private void f() {
        this.r.setProgress(0);
        this.r.setMax(0);
        this.i.post(new Runnable(){

            @Override
            public void run() {
                DefaultPlayerUIController.this.i.setText((CharSequence)"");
            }
        });
    }
}

