/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.androidyoutubeplayer.player;

import android.arch.lifecycle.Lifecycle;
import android.arch.lifecycle.LifecycleObserver;
import android.arch.lifecycle.OnLifecycleEvent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.YouTubePlayer;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.a;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.AbstractYouTubePlayerListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerFullScreenListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerInitListener;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.playerUtils.FullScreenHelper;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.playerUtils.PlaybackResumer;
import com.pierfrancescosoffritti.androidyoutubeplayer.ui.DefaultPlayerUIController;
import com.pierfrancescosoffritti.androidyoutubeplayer.ui.PlayerUIController;
import com.pierfrancescosoffritti.androidyoutubeplayer.utils.Callable;
import com.pierfrancescosoffritti.androidyoutubeplayer.utils.NetworkReceiver;
import com.pierfrancescosoffritti.androidyoutubeplayer.utils.Utils;

public class YouTubePlayerView
extends FrameLayout
implements LifecycleObserver,
NetworkReceiver.NetworkListener {
    @NonNull
    private final a a;
    @Nullable
    private DefaultPlayerUIController b;
    @NonNull
    private final NetworkReceiver c;
    @NonNull
    private final PlaybackResumer d;
    @NonNull
    private final FullScreenHelper e;
    @Nullable
    private Callable f;

    public YouTubePlayerView(Context context) {
        this(context, null);
    }

    public YouTubePlayerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public YouTubePlayerView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.a = new a(context);
        this.addView((View)this.a, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.b = new DefaultPlayerUIController(this, this.a);
        this.d = new PlaybackResumer();
        this.c = new NetworkReceiver(this);
        this.e = new FullScreenHelper();
        this.e.addFullScreenListener(this.b);
        this.a(this.a);
    }

    protected void onMeasure(int n, int n2) {
        if (this.getLayoutParams().height == -2) {
            int n3 = View.MeasureSpec.makeMeasureSpec((int)(View.MeasureSpec.getSize((int)n) * 9 / 16), (int)0x40000000);
            super.onMeasure(n, n3);
        } else {
            super.onMeasure(n, n2);
        }
    }

    public void initialize(final @NonNull YouTubePlayerInitListener youTubePlayerInitListener, boolean bl) {
        if (bl) {
            this.getContext().registerReceiver((BroadcastReceiver)this.c, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
        this.f = new Callable(){

            @Override
            public void call() {
                YouTubePlayerView.this.a.a(new YouTubePlayerInitListener(){

                    @Override
                    public void onInitSuccess(@NonNull YouTubePlayer youTubePlayer) {
                        youTubePlayerInitListener.onInitSuccess(youTubePlayer);
                    }
                });
            }
        };
        if (Utils.isOnline(this.getContext())) {
            this.f.call();
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
    public void release() {
        this.removeView((View)this.a);
        this.a.removeAllViews();
        this.a.destroy();
        try {
            this.getContext().unregisterReceiver((BroadcastReceiver)this.c);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnLifecycleEvent(value=Lifecycle.Event.ON_STOP)
    void onStop() {
        this.a.pause();
    }

    @Override
    public void onNetworkAvailable() {
        if (this.f != null) {
            this.f.call();
        } else {
            this.d.resume(this.a);
        }
    }

    @Override
    public void onNetworkUnavailable() {
    }

    @NonNull
    public PlayerUIController getPlayerUIController() {
        if (this.b == null) {
            throw new RuntimeException("You have inflated a custom player UI. You must manage it with your own controller.");
        }
        return this.b;
    }

    public View inflateCustomPlayerUI(@LayoutRes int n) {
        this.removeViews(1, this.getChildCount() - 1);
        if (this.b != null) {
            this.a.removeListener(this.b);
            this.e.removeFullScreenListener(this.b);
        }
        this.b = null;
        return View.inflate((Context)this.getContext(), (int)n, (ViewGroup)this);
    }

    public void enterFullScreen() {
        this.e.enterFullScreen((View)this);
    }

    public void exitFullScreen() {
        this.e.exitFullScreen((View)this);
    }

    public boolean isFullScreen() {
        return this.e.isFullScreen();
    }

    public void toggleFullScreen() {
        this.e.toggleFullScreen((View)this);
    }

    public boolean addFullScreenListener(@NonNull YouTubePlayerFullScreenListener youTubePlayerFullScreenListener) {
        return this.e.addFullScreenListener(youTubePlayerFullScreenListener);
    }

    public boolean removeFullScreenListener(@NonNull YouTubePlayerFullScreenListener youTubePlayerFullScreenListener) {
        return this.e.removeFullScreenListener(youTubePlayerFullScreenListener);
    }

    private void a(YouTubePlayer youTubePlayer) {
        if (this.b != null) {
            youTubePlayer.addListener(this.b);
        }
        youTubePlayer.addListener(this.d);
        youTubePlayer.addListener(new AbstractYouTubePlayerListener(){

            @Override
            public void onReady() {
                YouTubePlayerView.this.f = null;
            }
        });
    }
}

