/*
 * Decompiled with CFR 0.152.
 */
package com.pierfrancescosoffritti.androidyoutubeplayer.player;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.webkit.JavascriptInterface;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.PlayerConstants;
import com.pierfrancescosoffritti.androidyoutubeplayer.player.listeners.YouTubePlayerListener;
import java.util.Collection;

public class YouTubePlayerBridge {
    @NonNull
    private final YouTubePlayerBridgeCallbacks a;
    @NonNull
    private final Handler b;

    public YouTubePlayerBridge(@NonNull YouTubePlayerBridgeCallbacks youTubePlayerBridgeCallbacks) {
        this.a = youTubePlayerBridgeCallbacks;
        this.b = new Handler(Looper.getMainLooper());
    }

    @JavascriptInterface
    public void sendYouTubeIframeAPIReady() {
        this.a.onYouTubeIframeAPIReady();
    }

    @JavascriptInterface
    public void sendReady() {
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onReady();
                }
            }
        });
    }

    @JavascriptInterface
    public void sendStateChange(String string) {
        final PlayerConstants.PlayerState playerState = this.a(string);
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onStateChange(playerState);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackQualityChange(String string) {
        final PlayerConstants.PlaybackQuality playbackQuality = this.b(string);
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onPlaybackQualityChange(playbackQuality);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendPlaybackRateChange(String string) {
        final PlayerConstants.PlaybackRate playbackRate = this.c(string);
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onPlaybackRateChange(playbackRate);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendError(String string) {
        final PlayerConstants.PlayerError playerError = this.d(string);
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onError(playerError);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendApiChange() {
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onApiChange();
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoCurrentTime(String string) {
        float f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onCurrentSecond(f);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoDuration(String string) {
        float f;
        try {
            String string2 = TextUtils.isEmpty((CharSequence)string) ? "0" : string;
            f = Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onVideoDuration(f);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoLoadedFraction(String string) {
        float f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            return;
        }
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onVideoLoadedFraction(f);
                }
            }
        });
    }

    @JavascriptInterface
    public void sendVideoId(final String string) {
        this.b.post(new Runnable(){

            @Override
            public void run() {
                for (YouTubePlayerListener youTubePlayerListener : YouTubePlayerBridge.this.a.getListeners()) {
                    youTubePlayerListener.onVideoId(string);
                }
            }
        });
    }

    @NonNull
    private PlayerConstants.PlayerState a(String string) {
        PlayerConstants.PlayerState playerState = string.equalsIgnoreCase("UNSTARTED") ? PlayerConstants.PlayerState.UNSTARTED : (string.equalsIgnoreCase("ENDED") ? PlayerConstants.PlayerState.ENDED : (string.equalsIgnoreCase("PLAYING") ? PlayerConstants.PlayerState.PLAYING : (string.equalsIgnoreCase("PAUSED") ? PlayerConstants.PlayerState.PAUSED : (string.equalsIgnoreCase("BUFFERING") ? PlayerConstants.PlayerState.BUFFERING : (string.equalsIgnoreCase("CUED") ? PlayerConstants.PlayerState.VIDEO_CUED : PlayerConstants.PlayerState.UNKNOWN)))));
        return playerState;
    }

    @NonNull
    private PlayerConstants.PlaybackQuality b(String string) {
        PlayerConstants.PlaybackQuality playbackQuality = string.equalsIgnoreCase("small") ? PlayerConstants.PlaybackQuality.SMALL : (string.equalsIgnoreCase("medium") ? PlayerConstants.PlaybackQuality.MEDIUM : (string.equalsIgnoreCase("large") ? PlayerConstants.PlaybackQuality.LARGE : (string.equalsIgnoreCase("hd720") ? PlayerConstants.PlaybackQuality.HD720 : (string.equalsIgnoreCase("hd1080") ? PlayerConstants.PlaybackQuality.HD1080 : (string.equalsIgnoreCase("highres") ? PlayerConstants.PlaybackQuality.HIGH_RES : (string.equalsIgnoreCase("default") ? PlayerConstants.PlaybackQuality.DEFAULT : PlayerConstants.PlaybackQuality.UNKNOWN))))));
        return playbackQuality;
    }

    @NonNull
    private PlayerConstants.PlaybackRate c(String string) {
        PlayerConstants.PlaybackRate playbackRate = string.equalsIgnoreCase("0.25") ? PlayerConstants.PlaybackRate.RATE_0_25 : (string.equalsIgnoreCase("0.5") ? PlayerConstants.PlaybackRate.RATE_0_5 : (string.equalsIgnoreCase("1") ? PlayerConstants.PlaybackRate.RATE_1 : (string.equalsIgnoreCase("1.5") ? PlayerConstants.PlaybackRate.RATE_1_5 : (string.equalsIgnoreCase("2") ? PlayerConstants.PlaybackRate.RATE_2 : PlayerConstants.PlaybackRate.UNKNOWN))));
        return playbackRate;
    }

    @NonNull
    private PlayerConstants.PlayerError d(String string) {
        PlayerConstants.PlayerError playerError = string.equalsIgnoreCase("2") ? PlayerConstants.PlayerError.INVALID_PARAMETER_IN_REQUEST : (string.equalsIgnoreCase("5") ? PlayerConstants.PlayerError.HTML_5_PLAYER : (string.equalsIgnoreCase("100") ? PlayerConstants.PlayerError.VIDEO_NOT_FOUND : (string.equalsIgnoreCase("101") ? PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER : (string.equalsIgnoreCase("150") ? PlayerConstants.PlayerError.VIDEO_NOT_PLAYABLE_IN_EMBEDDED_PLAYER : PlayerConstants.PlayerError.UNKNOWN))));
        return playerError;
    }

    public static interface YouTubePlayerBridgeCallbacks {
        public void onYouTubeIframeAPIReady();

        public Collection<YouTubePlayerListener> getListeners();
    }
}

